unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, ToolWin, ImgList, ColorGrd, Menus;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    PaintBox1: TPaintBox;
    ToolBar1: TToolBar;
    Line: TToolButton;
    pencil: TToolButton;
    Eraser: TToolButton;
    ImageList1: TImageList;
    ToolBar2: TToolBar;
    square: TToolButton;
    FSquare: TToolButton;
    ToolBar3: TToolBar;
    Rsquare: TToolButton;
    FRsquare: TToolButton;
    ToolBar4: TToolBar;
    circle: TToolButton;
    FCircle: TToolButton;
    CoolBar1: TCoolBar;
    ColorGrid1: TColorGrid;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Splitter1: TSplitter;
    StatusBar1: TStatusBar;
    procedure LineClick(Sender: TObject);
    procedure ColorGrid1Click(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure N1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    IsDown: boolean;
    startP, endP: Tpoint;
    { Private declarations }
    procedure displayhint(sender: Tobject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure SetButtonValid;
var
  i: integer;
begin
  for i := 0 to form1.ComponentCount - 1 do
  begin
    if form1.Components[i] is TToolbutton then
      (form1.Components[i] as TToolbutton).down := false;
  end;
end;

procedure TForm1.LineClick(Sender: TObject);
begin
  if sender is Ttoolbutton then
  begin
    setbuttonvalid;
    with sender as Ttoolbutton do
      down := true;
  end;
end;

procedure TForm1.ColorGrid1Click(Sender: TObject);
begin
  paintbox1.Canvas.Pen.Color := colorgrid1.ForegroundColor;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
//갴µı־Ϊ
  IsDown := true;
  {Ǧʻ}
  if pencil.down then
    paintbox1.Canvas.MoveTo(x, y);
  {ֱ}
  if line.Down then
  begin
    startp.x := x;
    startp.y := y;
    endp.x := x;
    endp.y := y;
  end;
  {ǻƿľλǿԲǾΣԲ}
  if square.down or rsquare.down or circle.down then
  begin
    startp.x := x;
    startp.y := y;
    endp.x := x;
    endp.y := y;
  end;
{ǻʵľλʵԲǾΣʵԲ}
  if Fsquare.down or Frsquare.down or Fcircle.down then
  begin
    paintbox1.Canvas.brush.Color := colorgrid1.BackgroundColor;
    startp.x := x;
    startp.y := y;
    endp.x := x;
    endp.y := y;
  end;
end;

procedure TForm1.PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  IsDown := false;
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  //걻£з
  if Isdown then
  begin
    //Ǧʣֱߵµĵ
    if pencil.down then
      paintbox1.Canvas.LineTo(x, y);
    //ǻֱ
    if line.down then
    begin
      with paintbox1 do
      begin
        canvas.Pen.Color := clwhite;
        canvas.MoveTo(startP.x, startP.y);
        canvas.LineTo(endp.x, endp.y);
        canvas.Pen.Color := colorgrid1.ForegroundColor;
        canvas.MoveTo(startP.x, startP.y);
        canvas.LineTo(x, y);
        endp.x := x;
        endp.y := y;
      end;
    end;
    //Ƥ
    if eraser.down then
    begin
      with paintbox1.Canvas do
      begin
        brush.color := clwhite;
        FillRect(rect(x - 10, y - 10, x + 15, y + 15));
      end;
    end;
    //ǻƾ
    if square.down then
    begin
      with paintbox1.canvas do
      begin
        brush.color := clwhite;
        framerect(rect(startp.x, startp.y, endp.x, endp.y));
        endp.x := x;
        endp.y := y;
        brush.color := colorgrid1.ForegroundColor;
        framerect(rect(startp.x, startp.y, endp.x, endp.y));
      end;
    end;
    //ǻƴвɫ
    if Fsquare.Down then
    begin
      with paintbox1.Canvas do
      begin
        brush.Color := clWhite;
        fillrect(rect(startp.x, startp.y, endp.x, endp.y));
        endp.x := x;
        endp.y := y;
        brush.Color := colorgrid1.BackgroundColor;
        Fillrect(rect(startp.x, startp.y, endp.x, endp.y));
        brush.Color := colorgrid1.ForegroundColor;
        framerect(rect(startp.x, startp.y, endp.x, endp.y));
      end;
    end;
    //ǻԲǾ
    if Rsquare.down then
    begin
      with paintbox1.Canvas do
      begin
        brush.Color := clWhite;
        pen.color := clwhite;
        roundrect(startp.x, startp.y, endp.x, endp.y, (startp.x - endp.x) div 2
          , (startp.y - endp.y) div 2);
        endp.x := x;
        endp.y := y;
        pen.color := colorgrid1.ForegroundColor;
        roundrect(startp.x, startp.y, endp.x, endp.y, (startp.x - endp.x) div 2
          , (startp.y - endp.y) div 2);
      end;
    end;
    //ôвɫԲǾ
    if FRsquare.down then
    begin
      with paintbox1.canvas do
      begin
        brush.color := clwhite;
        pen.Color := clwhite;
        roundrect(startp.x, startp.y, endp.x, endp.y, (startp.x - endp.x) div 2
          , (startp.y - endp.y) div 2);
        endp.x := x;
        endp.y := y;
        pen.color := colorgrid1.ForegroundColor;
        brush.Color := colorgrid1.BackgroundColor;
        roundrect(startp.x, startp.y, endp.x, endp.y, (startp.x - endp.x) div 2
          , (startp.y - endp.y) div 2);
      end;
    end;
    //ǻԲ
    if circle.down then
    begin
      with paintbox1.Canvas do
      begin
        pen.color := clwhite;
        arc(startp.x, startp.y, endp.x, endp.y, startp.x,
          startp.y, startp.x, startp.y);
        endp.x := x;
        endp.y := y;
        pen.color := colorgrid1.ForegroundColor;
        arc(startp.x, startp.y, endp.x, endp.y, startp.x,
          startp.y, startp.x, startp.y);
      end;
    end;
    //ǻƴвɫԲ
    if Fcircle.down then
    begin
      with paintbox1.Canvas do
      begin
        brush.color := clwhite;
        pen.color := clwhite;
        ellipse(startp.x, startp.y, endp.x, endp.y);
        endp.x := x;
        endp.y := y;
        pen.Color := colorgrid1.ForegroundColor;
        brush.Color := colorgrid1.BackgroundColor;
        ellipse(startp.x, startp.y, endp.x, endp.y);
        arc(startp.x, startp.y, endp.x, endp.y, startp.x
          , startp.y, startp.x, startp.y);
      end;
    end;
  end;
end;

procedure TForm1.N1Click(Sender: TObject);
var
  rect: Trect;
  filename: string;
begin
  if savedialog1.Execute then
  begin
    rect.left := 0;
    rect.top := 0;
    rect.right := paintbox1.Width;
    rect.bottom := paintbox1.Height;
    with Tbitmap.create do
    begin
      try
        width := rect.right;
        height := rect.bottom;
        Canvas.CopyRect(rect, paintbox1.Canvas, rect);
        filename := savedialog1.FileName;
        if extractfileext(filename) = '' then
          filename := filename + '.bmp';
        SaveToFile(filename);
      finally
        Free;
      end;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  application.onhint := displayhint;
end;

procedure TForm1.displayhint(sender: Tobject);
begin
  statusbar1.panels[0].text := application.hint;
  statusbar1.refresh;
end;
end.

