/*
 Written by: Paul E. Martz
 Copyright 1997 by Paul E. Martz, all right reserved
 Non-commercial use by individuals is permitted.
 עͣƷѩ pinxue@263.net 1999.8.
*/

#include <stdio.h>
#include <stdlib.h>
#include "math.h"

#include "fractmod.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WINDOWS
/* ΪHPUXдWin32*/
#define random() rand()
#define srandom(x) srand(x)
#endif

/*
 һ(minmax)ֵ֮
 һΧΪ32767ֵ
 */
static float randnum (float min, float max)
{
	int r;
    float	x;
    
	r = random ();
    x = (float)(r & 0x7fff) /
		(float)0x7fff;
    return (x * (max - min) + min);
} 


/*
 randnumļ򻯽
 */
#define fractRand(v) randnum (-v, v)

/*
 еi߶ζ˵ֵƽֵ
 *
 * Called by fill1DFractArray.
 */
static float avgEndpoints (int i, int stride, float *fa)
{
    return ((float) (fa[i-stride] +
		     fa[i+stride]) * .5f);
}

/*
׶Ľǵƽֵ(i,j)Ϊ׶ĵ㣬
strideΪĵǵݺ sizeݺ
Σݺȡ

ע⣬sizeΪݺ򶥵subSizeΪ߶ά
      size=subSize+1;

Called by fill2DFractArray.
*/
static float avgDiamondVals (int i, int j, int stride,
			     int size, int subSize, float *fa)
{
/*	   Ϊ֧б޷ƴӣ(i,j)ĳʱҪرע⡣
	   ͷif䴦顣elseһi,jڱ߽ϣ*/
    if (i == 0)
	return ((float) (fa[(i*size) + j-stride] +  //j-strid
			 fa[(i*size) + j+stride] +          //j+strid
			 fa[((subSize-stride)*size) + j] +  //i-stridڣöԱϵĶ
			 fa[((i+stride)*size) + j]) * .25f);//i+strid
    else if (i == size-1)
	return ((float) (fa[(i*size) + j-stride] +  //j-strid
			 fa[(i*size) + j+stride] +          //j+strid
			 fa[((i-stride)*size) + j] +        //i-strid
			 fa[((0+stride)*size) + j]) * .25f);//i+stridڣöԱϵĶ
    else if (j == 0)
	return ((float) (fa[((i-stride)*size) + j] +
			 fa[((i+stride)*size) + j] +
			 fa[(i*size) + j+stride] +
			 fa[(i*size) + subSize-stride]) * .25f);
    else if (j == size-1)
	return ((float) (fa[((i-stride)*size) + j] +
			 fa[((i+stride)*size) + j] +
			 fa[(i*size) + j-stride] +
			 fa[(i*size) + 0+stride]) * .25f);
    else
	return ((float) (fa[((i-stride)*size) + j] + //i-strid
			 fa[((i+stride)*size) + j] +         //i+strid
			 fa[(i*size) + j-stride] +           //j-strid
			 fa[(i*size) + j+stride]) * .25f);   //j+strid
}


/*
 ƽ λ(i,j)Ľǵֵ
 strideΪα߳ȡ
X.X
.*.
X.X
׶ͬβб߽⡣
 Called by fill2DFractArray.
*/
static float avgSquareVals (int i, int j, int stride, int size, float *fa)
{
    return ((float) (fa[((i-stride)*size) + j-stride] +
		     fa[((i-stride)*size) + j+stride] +
		     fa[((i+stride)*size) + j-stride] +
		     fa[((i+stride)*size) + j+stride]) * .25f);
}

/*жsizeǷΪ2Ĵη򷵻1ǻΪ0򷵻0*/
static int powerOf2 (int size)
{
    int i, bitcount = 0;
    /* Ĵٶsizeof(int)*8һλ
	    ڶƽ̨ */
    for (i=0; i<sizeof(int)*8; i++)
	if (size & (1<<i))
	    bitcount++;
    if (bitcount == 1)
	/* ע2ηֻһλΪ1 */
	return (1);
    else
	return (0);
}


/*ƴǶһֵΪƷβ˶ */
void fill1DFractArray (float *fa, int size,
		       int seedValue, float heightScale, float h)
{
    int	i;
    int	stride;
    int subSize;
	float ratio, scale;

    if (!powerOf2(size) || (size==1)) { return; }

    subSize = size;
    size++;
    
    srandom (seedValue);


	/* 趨ǵĴֲڶȳ
	   ʼ0.01.0Χɡ
	   scaleÿεscaleratioЧļΧ*/
	ratio = (float) pow (2.,-h);
	scale = heightScale * ratio;

    /* вֶ˵㡣Ҫʵ޷ƴӣЩ˵ͬ*/
    stride = subSize / 2;
    fa[0] =
      fa[subSize] = 0.f;

    while (stride) {
		for (i=stride; i<subSize; i+=stride) {
			fa[i] = scale * fractRand (.5f) +
				avgEndpoints (i, stride, fa);
			/* reduce random number range */
			scale *= ratio;
			i+=stride;
		}
		stride >>= 1;
    }
}


/*diamond-square㷨ƴǶһάθ߶ͼ*/
void fill2DFractArray (float *fa, int size,
		       int seedValue, float heightScale, float h)
{
    int	i, j;
    int	stride;
    int	oddline;
    int subSize;
	float ratio, scale;
	//ֻάΪ2η
    if (!powerOf2(size) || (size==1)) { return; }

    /* subSize ݺ߶Ƶά
       segments ԶƵά
	*/
    subSize = size;
    size++;
    
    /* initialize random number generator */
    srandom (seedValue);
    
	/* 趨ǵĴֲڶȳ
	   ʼ0.01.0Χɡ
	   scaleÿεscaleratioЧļΧ*/
	ratio = (float) pow (2.,-h);
	scale = heightScale * ratio;

    /* ǰĸֵһ4X4飬ǽʼ±*ĵ㣺
           * . . . *
           . . . . .
           . . . . .
           . . . . .
           * . . . *
       diamond-square㷨⽫Ρ
       ĽǸֵͬʹʱ޷ƴ*/

    stride = subSize / 2;
    fa[(0*size)+0] =
      fa[(subSize*size)+0] =
        fa[(subSize*size)+subSize] =
          fa[(0*size)+subSize] = 0.f;
    
    /*׶ֵϸڡ
	strideѭ,ÿѭĩβὫstride룬
	ֱstrideΪ0ʱ */
    while (stride) {
		/* squarediamondݡ
		   һ龭4X4ʱΪ±ߵX
		   Ҫ*ݣ
               X . . . X
               . . . . .
               . . * . .
               . . . . .
               X . . . X
        */
		for (i=stride; i<subSize; i+=stride) {
			for (j=stride; j<subSize; j+=stride) {
				fa[(i * size) + j] =
					scale * fractRand (.5f) +
					avgSquareVals (i, j, stride, size, fa);
				j += stride;
			}
			i += stride;
		}

		/* diamondsquareݡ
		   һ龭δʱΪ±ߵX
		   Ҫ*ݣ
               X . * . X
               . . . . .
               * . X . *
               . . . . .
               X . * . X
	       i,jе(x,y)λáɵĵһֵλ(i=2,j=0)
		   "oddline""stride"jֵ
	    */
		oddline = 0;
		for (i=0; i<subSize; i+=stride) {
		    oddline = (oddline == 0);
			for (j=0; j<subSize; j+=stride) {
				if ((oddline) && !j) j+=stride;

				/* i and j are setup. Call avgDiamondVals with the
				   current position. It will return the average of the
				   surrounding diamond data points. */
				fa[(i * size) + j] =
					scale * fractRand (.5f) +
					avgDiamondVals (i, j, stride, size, subSize, fa);

				/* To wrap edges seamlessly, copy edge values around
				   to other side of array */
				if (i==0)
					fa[(subSize*size) + j] =
						fa[(i * size) + j];
				if (j==0)
					fa[(i*size) + subSize] =
						fa[(i * size) + j];

				j+=stride;
			}
		}

		/* reduce random number range. */
		scale *= ratio;
		stride >>= 1;
    }

}


/*
 * alloc1DFractArray - Allocate float-sized data points for a 1D strip
 * containing size line segments.
 */
float *alloc1DFractArray (int size)
{
    /* Increment size (see comment in alloc2DFractArray, below, for an
       explanation). */
    size++;

    return ((float *) malloc (sizeof(float) * size));
}

/*
 * alloc2DFractArray - Allocate float-sized data points for a sizeXsize
 * mesh.
 */
float *alloc2DFractArray (int size)
{
    /* For a sizeXsize array, we need (size+1)X(size+1) space. For
       example, a 2x2 mesh needs 3x3=9 data points: 

           *   *   *

           *   *   *

           *   *   *

       To account for this, increment 'size'. */
    size++;

    return ((float *) malloc (sizeof(float) * size * size));
}



/*
 * freeFractArray - Takes a pointer to float and frees it. Can be used
 * to free data that was allocated by either alloc1DFractArray or
 * alloc2DFractArray.
 */
void freeFractArray (float *fa)
{
    free (fa);
}


extern void draw2DLine (float, float, float, float);
/* ע⣬Ҫʹdraw1DFractArrayAsLinesƳ߶ҪԼ
   ĸdraw2DLineΪ˵x,yꡣ*/
void draw1DFractArrayAsLines (float *fa, int size)
{
    int	i;
    float	x, inc;

    inc = 2.f / size;
    x = -1.f;
    for (i=0; i<size; i++) {
	draw2DLine (x, fa[i],
		    x+inc, fa[i+1]);
	x += inc;
    }
}

/* ע⣬Ҫʹdraw2DFractArrayAsLinesƳҪԼ
   draw3DLineΪ˵x,y,zꡣ*/
void draw2DFractArrayAsLines (float *fa, int size)
{
    extern void draw3DLine (float, float, float, float, float, float);
    int	i, j;
    float	x, z, inc;
    const int	subSize = size;

    size++;
    inc = 2.f / subSize;
    z = -1.f;
    for (i=0; i<size; i++) {
	x = -1.f;
	for (j=0; j<subSize; j++) {
	    draw3DLine (x, fa[(i*size)+j], z,
			x+inc, fa[(i*size+j+1)], z);
	    if (i<subSize)
		draw3DLine (x, fa[(i*size)+j], z,
			    x, fa[((i+1)*size+j)], z+inc);
	    x += inc;
	}
	if (i<subSize)
	    draw3DLine (x, fa[(i*size)+j], z,
			x, fa[((i+1)*size+j)], z+inc);
	z += inc;
    }
}

/*㣬Ϊʸ˻ƽ淨*/
static void genNormal (float x1, float y1, float z1,
		       float x2, float y2, float z2,
		       float x3, float y3, float z3,
		       float *normal)
{
    float	len;
    float	v1x, v1y, v1z;
    float	v2x, v2y, v2z;
    v1x = x2 - x1;
    v1y = y2 - y1;
    v1z = z2 - z1;
    v2x = x3 - x1;
    v2y = y3 - y1;
    v2z = z3 - z1;
    normal[0] = v1y*v2z - v1z*v2y;
    normal[1] = v1z*v2x - v1x*v2z;
    normal[2] = v1x*v2y - v1y*v2x;
    len = (float) sqrt (normal[0]*normal[0] + normal[1]*normal[1] +
			normal[2]*normal[2]);
    normal[0] /= len;
    normal[1] /= len;
    normal[2] /= len;
}

/*
  һϵдӦλƸ߶ͼ
  Ǹ򻯵ԱﵽĿĲУʾαһ顣
  Ҫʹ̣Լ"draw3DTriangle"
  12ͷ9x,y,z꣬
  3ǵλ淨x,y,zѿֵ
  x,zḲ-1.01.0ӦY꽫ӷȡ
  οϡ+yɣ˳Ӧʹַ뷨򱣳һ¡
  ַ򣺴ӷָϿ㰴ʱУ
 */
void draw2DFractArrayAsTriangles (float *fa, int size)
{
    extern void draw3DTriangle (float, float, float, float, float, float,
				float, float, float, float, float, float);
    int	i, j;
    float	x, z, inc;
    const int	subSize = size;

    size++;
    inc = 2.f / subSize;
    z = -1.f;
    for (i=0; i<subSize; i++) {
	x = -1.f;
	for (j=0; j<subSize; j++) {
	    float	normal[3];

	    genNormal (x, fa[(i*size)+j], z,
		       x, fa[((i+1)*size)+j], z+inc,
		       x+inc, fa[(i*size+j+1)], z,
		       normal);
	    draw3DTriangle (x, fa[(i*size)+j], z,
			    x, fa[((i+1)*size)+j], z+inc,
			    x+inc, fa[(i*size+j+1)], z,
			    normal[0], normal[1], normal[2]);

	    genNormal (x, fa[((i+1)*size)+j], z+inc,
		       x+inc, fa[((i+1)*size)+j+1], z+inc,
		       x+inc, fa[(i*size+j+1)], z,
		       normal);
	    draw3DTriangle (x, fa[((i+1)*size)+j], z+inc,
			    x+inc, fa[((i+1)*size)+j+1], z+inc,
			    x+inc, fa[(i*size+j+1)], z,
			    normal[0], normal[1], normal[2]);

	    x += inc;
	}
	z += inc;
    }
}

#ifdef __cplusplus
}
#endif