#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h> 
#include <GL\glaux.h>  
#define RAMPSIZE 16 
#define RAMPSTART 32  

void myinit(void) 
{     
	int i;      
	for (i = 0; i < RAMPSIZE; i++) 
	   {         
		 GLfloat shade;         
		 shade = (GLfloat) i/(GLfloat) RAMPSIZE;
		 auxSetOneColor(RAMPSTART+(GLint)i, shade, shade, shade);     
		}      

	glEnable (GL_LINE_SMOOTH);     
	glHint (GL_LINE_SMOOTH_HINT, GL_DONT_CARE);     
	glLineWidth (1.5);     
	glClearIndex ((GLfloat) RAMPSTART);     
	glShadeModel(GL_FLAT);     
	glDepthFunc(GL_LEQUAL);     
	glEnable(GL_DEPTH_TEST); 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     
	glIndexi(RAMPSTART);     
	auxWireIcosahedron(1.0);     
	glFlush(); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	gluPerspective (45.0, (GLfloat) w/(GLfloat) h, 3.0, 5.0);
	glMatrixMode(GL_MODELVIEW);     
	glLoadIdentity ();     
	glTranslatef (0.0, 0.0, -4.0);  
}   

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_INDEX | AUX_DEPTH);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ8-4");
    myinit();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
