#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h> 
#include <GL/glaux.h>
  
GLfloat diffuseMaterial[4] = { 0.5, 0.5, 0.5, 1.0 };  

void myinit(void) 
{     
	GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };     
	GLfloat light_position[] = { 1.0, 1.0, 1.0, 0.0 };      
	glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);     
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);     
	glMaterialf(GL_FRONT, GL_SHININESS, 25.0);     
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);      
	glEnable(GL_LIGHTING);     
	glEnable(GL_LIGHT0);     
	glDepthFunc(GL_LEQUAL);     
	glEnable(GL_DEPTH_TEST);      
	glColorMaterial(GL_FRONT, GL_DIFFUSE);     
	glEnable(GL_COLOR_MATERIAL); 
}  

void CALLBACK changeRedDiffuse (AUX_EVENTREC *event) 
{     
	diffuseMaterial[0] += 0.1;     
	if (diffuseMaterial[0] > 1.0)         
		  diffuseMaterial[0] = 0.0;     
	glColor4fv(diffuseMaterial); 
}  

void CALLBACK changeGreenDiffuse (AUX_EVENTREC *event) 
{     
	diffuseMaterial[1] += 0.1;     
	if (diffuseMaterial[1] > 1.0)         
		diffuseMaterial[1] = 0.0;     
	glColor4fv(diffuseMaterial); 
}  

void CALLBACK changeBlueDiffuse (AUX_EVENTREC *event) 
{     
	diffuseMaterial[2] += 0.1;     
	if (diffuseMaterial[2] > 1.0)         
		diffuseMaterial[2] = 0.0;     
	glColor4fv(diffuseMaterial); 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     
	auxSolidSphere(1.0);     
	glFlush(); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	if (w <= h)          
	   glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w,              
	5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);     
	else          
	   glOrtho (-1.5*(GLfloat)w/(GLfloat)h,  1.5*(GLfloat)w/(GLfloat)h, 
				-1.5, 1.5, -10.0, 10.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}  

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA | AUX_DEPTH);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ7-3");
    myinit();
    auxMouseFunc(AUX_LEFTBUTTON, AUX_MOUSEDOWN, 
        changeRedDiffuse);
    auxMouseFunc(AUX_MIDDLEBUTTON, AUX_MOUSEDOWN, 
        changeGreenDiffuse);
    auxMouseFunc(AUX_RIGHTBUTTON, AUX_MOUSEDOWN, 
        changeBlueDiffuse);
    auxReshapeFunc(myReshape);
    auxMainLoop(display);
	return 0;
}

