#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h> 
#include <GL/glaux.h>  

void myinit (void) 
{     
    glShadeModel (GL_SMOOTH);   /* GL_SMOOTH Ϊȱʡ״̬ */ 
}  

void triangle(void) 
{   
    glBegin (GL_TRIANGLES); 
    glColor3f (1.0, 0.0, 0.0);   
    glVertex2f (6.0, 6.0);   
    glColor3f (0.0, 1.0, 0.0);  
    glVertex2f (26.0, 6.0); 
    glColor3f (0.0, 0.0, 1.0); 
    glVertex2f (6.0, 26.0);
    glEnd ();
}  

void CALLBACK display(void) 
{  
    glClear (GL_COLOR_BUFFER_BIT);
    triangle ();
    glFlush (); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h)
 { 
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    if (w <= h)  
       gluOrtho2D (0.0, 30.0, 0.0,    
                     30.0 * (GLfloat) h/(GLfloat) w);
    else  
       gluOrtho2D (0.0, 30.0 * (GLfloat) w/(GLfloat) h, 0.0,  
            30.0);
    glMatrixMode(GL_MODELVIEW);
 }   

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ6-1");
    myinit();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
 
