#include <windows.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glaux.h> 

static int year = 0, day = 0; 

static void CALLBACK dayAdd(void)
{
    day = (day + 10) % 360;
} 

static void CALLBACK daySubtract(void)
{
    day = (day - 10) % 360; 
} 

static void CALLBACK yearAdd(void) 
{    
    year = (year + 5) % 360; 
}  

static void CALLBACK yearSubtract(void) 
{     
    year = (year - 5) % 360; 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT);     
	glColor3f (1.0, 0.0, 0.0);     
	glPushMatrix();         
	auxSolidSphere(1.0);        /* ̫ */         
	glRotatef((GLfloat) year, 0.0, 1.0, 0.0);         
	glTranslatef (2.0, 0.0, 0.0);         
	glRotatef((GLfloat) day, 0.0, 1.0, 0.0);         
	glColor3f (0.0, 0.0, 1.0);     
	auxSolidSphere(0.2);        /* С */
	glPopMatrix();
	glFlush();
}

void myinit(void)  
{     
     glShadeModel(GL_FLAT);
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	gluPerspective(60.0,(GLfloat)w/(GLfloat)h,1.0,20.0);
	glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();    
    glTranslatef (0.0, 0.0, -5.0); 
}  

int main(int argc, char** argv)
{
    auxInitDisplayMode(AUX_SINGLE | AUX_RGBA);
    auxInitPosition(0, 0, 500, 500);
    auxInitWindow("ָ4-6");
    myinit();
    auxKeyFunc(AUX_LEFT, yearSubtract);
    auxKeyFunc(AUX_RIGHT, yearAdd);
    auxKeyFunc(AUX_UP, dayAdd);
    auxKeyFunc(AUX_DOWN, daySubtract);
    auxReshapeFunc(myReshape);
    auxMainLoop(display);

	return 0;
}

