#include <windows.h>

#include <GL/gl.h> 
#include <GL/glu.h> 
#include <GL/glaux.h>  

#define   stripeImageWidth 32 
GLubyte   stripeImage[3*stripeImageWidth];  

void CALLBACK loadStripeImage(void) 
{     
	int j;      
	for (j = 0; j < stripeImageWidth; j++) 
	{         
	   stripeImage[3*j] = (j<=4) ? 255 : 0;         
	   stripeImage[3*j+1] = (j>4) ? 255 : 0;         
	   stripeImage[3*j+2] = 0;     
	} 
}  

GLfloat sgenparams[] = {1.0, 0.0, 0.0, 0.0};  

void CALLBACK myinit(void) 
{     
	glClearColor (0.0, 0.0, 0.0, 0.0);      
	loadStripeImage();     
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);     
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glTexParameterf(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER,  GL_LINEAR);
	glTexParameterf(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER,  GL_LINEAR);
	glTexImage1D(GL_TEXTURE_1D, 0, 3, stripeImageWidth, 0,         
				 GL_RGB, GL_UNSIGNED_BYTE, stripeImage);     
	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);     
	glTexGenfv(GL_S, GL_OBJECT_PLANE, sgenparams);     
	glEnable(GL_DEPTH_TEST);     
	glDepthFunc(GL_LEQUAL);     
	glEnable(GL_TEXTURE_GEN_S);     
	glEnable(GL_TEXTURE_1D);     
	glEnable(GL_CULL_FACE);     
	glEnable(GL_LIGHTING);     
	glEnable(GL_LIGHT0);     
	glEnable(GL_AUTO_NORMAL);     
	glEnable(GL_NORMALIZE);     
	glFrontFace(GL_CW);     
	glCullFace(GL_BACK);     
	glMaterialf (GL_FRONT, GL_SHININESS, 64.0); 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     
	glPushMatrix ();         
	glRotatef(45.0, 0.0, 0.0, 1.0);         
	auxSolidTeapot(2.0);     
	glPopMatrix ();     
	glFlush(); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	if (w <= h) 
			  glOrtho (-3.5, 3.5, -3.5*(GLfloat)h/(GLfloat)w,  
						3.5*(GLfloat)h/(GLfloat)w, -3.5, 3.5);     
	else   
			  glOrtho (-3.5*(GLfloat)w/(GLfloat)h,
						3.5*(GLfloat)w/(GLfloat)h, -3.5, 3.5, -3.5, 3.5);   
	glMatrixMode(GL_MODELVIEW);     
	glLoadIdentity(); 
} 

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA | AUX_DEPTH);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ10-3");
    myinit();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
