
#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h> 
#include <GL\glaux.h>  

#define NUMCOLORS 32 
#define RAMPSTART 16  

void myinit(void) 
{     
	int i;      
	glEnable(GL_DEPTH_TEST);     
	glDepthFunc(GL_LEQUAL);     
	for (i = 0; i < NUMCOLORS; i++) 
	{        
	 GLfloat shade;         
	 shade = (GLfloat) (NUMCOLORS-i)/(GLfloat) NUMCOLORS;         
	 auxSetOneColor (16 + i, shade, shade, shade);     
	}     
	glEnable(GL_FOG);      
	glFogi (GL_FOG_MODE, GL_LINEAR);     
	glFogi (GL_FOG_INDEX, NUMCOLORS);     
	glFogf (GL_FOG_START, 0.0);     
	glFogf (GL_FOG_END, 4.0);     
	glHint (GL_FOG_HINT, GL_NICEST);     
	glClearIndex((GLfloat) (NUMCOLORS+RAMPSTART-1)); 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     
	glPushMatrix ();         
	glTranslatef (-1.0, -1.0, -1.0);         
	glRotatef (-90.0, 1.0, 0.0, 0.0);         
	glIndexi (RAMPSTART);         
	auxSolidCone(1.0, 2.0);     
	glPopMatrix ();      
	glPushMatrix ();         
	glTranslatef (0.0, -1.0, -2.25);         
	glRotatef (-90.0, 1.0, 0.0, 0.0);         
	glIndexi (RAMPSTART);         
	auxSolidCone(1.0, 2.0);     
	glPopMatrix ();     glPushMatrix ();         
	glTranslatef (1.0, -1.0, -3.5);         
	glRotatef (-90.0, 1.0, 0.0, 0.0);         
	glIndexi (RAMPSTART);         
	auxSolidCone(1.0, 2.0);     
	glPopMatrix ();     
	glFlush(); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		if (w <= h)
			glOrtho (-2.0, 2.0, -2.0*(GLfloat)h/(GLfloat)w, 
				2.0*(GLfloat)h/(GLfloat)w, 0.0, 10.0);
		else
			glOrtho (-2.0*(GLfloat)w/(GLfloat)h, 
				2.0*(GLfloat)w/(GLfloat)h, -2.0, 2.0, 0.0, 10.0);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity ();
}  

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_INDEX | AUX_DEPTH);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ8-7");
    myinit();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}

