#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h> 
#include <GL\glaux.h>  

void myinit(void) 
{     
	GLfloat values[2];     
	glGetFloatv(GL_LINE_WIDTH_GRANULARITY, values);     
	printf("GL_LINE_WIDTH_GRANULARITY value is %3.1f\n",
			values[0]); 
	glGetFloatv(GL_LINE_WIDTH_RANGE, values);     
	printf("GL_LINE_WIDTH_RANGE values are %3.1f %3.1f\n", 
			values[0], values[1]);
	glEnable(GL_LINE_SMOOTH);     
	glEnable(GL_BLEND);     
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);     
	glLineWidth(1.5);      
	glShadeModel(GL_FLAT);     
	glClearColor(0.0, 0.0, 0.0, 0.0);     
	glDepthFunc(GL_LEQUAL);     
	glEnable(GL_DEPTH_TEST); 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     
	glColor4f(1.0, 1.0, 1.0, 1.0);     
	auxWireIcosahedron(1.0);     
	glFlush(); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	gluPerspective(45.0, (GLfloat) w/(GLfloat) h, 3.0, 5.0); 
	glMatrixMode(GL_MODELVIEW);     
	glLoadIdentity();     
	glTranslatef(0.0, 0.0, -4.0);  
}   

int main(int argc, char** argv) 
{     
	auxInitDisplayMode(AUX_SINGLE | AUX_RGBA | AUX_DEPTH);     
	auxInitPosition(0, 0, 300, 300);
	auxInitWindow("ָ8-3");
	myinit();
	auxReshapeFunc(myReshape);
	auxMainLoop(display);
	return 0;
}
