#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h>
#include <GL\glaux.h>  

void myinit(void) 
{     
	glEnable(GL_BLEND);     
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);     
	glShadeModel(GL_FLAT);     
	glClearColor(0.0, 0.0, 0.0, 0.0); 
}  

void CALLBACK display(void) 
{     
	glClear(GL_COLOR_BUFFER_BIT);      
	glColor4f(1.0, 1.0, 0.0, 0.75);     
	glRectf(0.0, 0.0, 0.5, 1.0);      
	glColor4f(0.0, 1.0, 1.0, 0.75);     
	glRectf(0.0, 0.0, 1.0, 0.5);  

	/* Ͻ෴ɫ */     
	
	glColor4f (0.0, 1.0, 1.0, 0.75);     
	glRectf (0.5, 0.5, 1.0, 1.0);      
	glColor4f (1.0, 1.0, 0.0, 0.75);     
	glRectf (0.5, 0.5, 1.0, 1.0);      
	glFlush(); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{     
	glViewport(0, 0, w, h);     
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	if (w <= h)          
		gluOrtho2D (0.0, 1.0, 0.0, 1.0*(GLfloat)h/(GLfloat)w);     
	else          
		gluOrtho2D (0.0, 1.0*(GLfloat)w/(GLfloat)h, 0.0, 1.0);     
	glMatrixMode(GL_MODELVIEW);
}  

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ8-1");
    myinit();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
