#include "windows.h"

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glaux.h> 
 
static int spin = 0;  

void CALLBACK movelight (AUX_EVENTREC *event) 
{   
  spin = (spin + 10) % 360;
}  

void myinit (void) 
{    
 glEnable(GL_LIGHTING);    
 glEnable(GL_LIGHT0);    
 glDepthFunc(GL_LEQUAL);      
 glEnable(GL_DEPTH_TEST); 
}  

void CALLBACK display(void) 
{   
  GLfloat position[] = { 0.0, 0.0, 1.5, 1.0 };    
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);    
  glPushMatrix ();       
  glTranslatef (0.0, 0.0, -5.0);         
  glPushMatrix ();           
  glRotated ((GLdouble) spin, 1.0, 0.0, 0.0);           
  glRotated (0.0, 1.0, 0.0, 0.0);           
  glLightfv (GL_LIGHT0, GL_POSITION, position);           
  glTranslated (0.0, 0.0, 1.5);            
  glDisable (GL_LIGHTING);            
  glColor3f (0.0, 1.0, 1.0);          
  auxWireCube (0.1);          
  glEnable (GL_LIGHTING);      
  glPopMatrix ();        
  auxSolidTorus (0.275, 0.85);   
  glPopMatrix ();    
  glFlush (); 
}  

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{    
  glViewport(0, 0, w, h);   
  glMatrixMode(GL_PROJECTION);   
  glLoadIdentity();
  gluPerspective(40.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
  glMatrixMode(GL_MODELVIEW);
}  

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA | AUX_DEPTH);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ7-2");
    myinit();
    auxMouseFunc (AUX_LEFTBUTTON, AUX_MOUSEDOWN, movelight);
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
