#include "windows.h"

#include <GL/gl.h> 
#include <GL/glu.h>
#include <GL/glaux.h>  

void myinit(void) 
{   
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };   
   GLfloat mat_shininess[] = { 100.0 }; 
   GLfloat light_position[] = { 1.0, 1.0, 1.0, 0.0 };   
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular); 
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess); 
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);  
   glEnable(GL_LIGHTING);   
   glEnable(GL_LIGHT0);   
   glDepthFunc(GL_LEQUAL);   
   glEnable(GL_DEPTH_TEST);
}  

void CALLBACK display(void) 
{  
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);   
   auxSolidSphere(1.0);   
   glFlush();
}

void CALLBACK myReshape(GLsizei w, GLsizei h) 
{    
    glViewport(0, 0, w, h);   
    glMatrixMode(GL_PROJECTION);   
    glLoadIdentity();
    if (w <= h) 
        glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w, 
            1.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
    else 
        glOrtho (-1.5*(GLfloat)w/(GLfloat)h, 
            1.5*(GLfloat)w/(GLfloat)h, -1.5, 1.5, -10.0, 10.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}  

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA | AUX_DEPTH);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ7-1");
    myinit();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}

