#include <windows.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glaux.h> 

static int shoulder = 0, elbow = 0;
static int finger1=0; 

static void CALLBACK elbowAdd (void)
{
    elbow = (elbow + 5) % 360;
} 
static void CALLBACK  elbowSubtract (void)
{
    elbow = (elbow - 5) % 360;
} 
static void CALLBACK  shoulderAdd (void)
{
    shoulder = (shoulder + 5) % 360;
}
static void CALLBACK  shoulderSubtract (void)
{
    shoulder = (shoulder - 5) % 360;
} 

static void CALLBACK finger1Add(void)
{
    finger1 = (finger1 + 10) % 360;
	if(finger1>90)
		finger1=90;
}
static void CALLBACK  finger1Subtract (void)
{
    finger1 = (finger1 - 10) % 360;
	if(finger1<-90)
		finger1=-90;
} 

static void CALLBACK  display(void)
{
    glClear(GL_COLOR_BUFFER_BIT);
    glColor3f (0.0, 0.0, 0.0); 
    glPushMatrix();
        glTranslatef (-1.0, 0.0, 0.0);
        glRotatef ((GLfloat) shoulder, 0.0, 0.0, 1.0);
        glTranslatef (1.0, 0.0, 0.0);
        auxWireBox(2.0, 0.4, 1.0);      /*  */ 
        glTranslatef (1.0, 0.0, 0.0);
        glRotatef ((GLfloat) elbow, 0.0, 0.0, 1.0);
        glTranslatef (1.0, 0.0, 0.0);
        auxWireBox(2.0, 0.4, 1.0);      /*  */ 
		glTranslatef(1.0, 0.0, 0.0);
		glRotatef((GLfloat) finger1, 0.0, 0.0, 1.0);
		glTranslatef(0.2, 0.0, 0.0);
		auxSolidBox(0.4, 0.1, 0.2);
	glPopMatrix();
    glFlush();
}
void myinit (void)  
{  
	glClearColor(192.0/255.0, 192.0/255.0, 192.0/255.0, 1.0);
	glShadeModel(GL_FLAT);
}  
static void CALLBACK  myReshape(GLsizei w, GLsizei h) 
{   
	glViewport(0, 0, w, h); 
	glMatrixMode(GL_PROJECTION);     
	glLoadIdentity();     
	gluPerspective(65.0,(GLfloat)w/(GLfloat)h,1.0,20.0);     
	glMatrixMode(GL_MODELVIEW);     
	glLoadIdentity();     
	glTranslatef(0.0, 0.0, -5.0); 
}   
int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA);
    auxInitPosition (0, 0, 400, 400);
    auxInitWindow ("ָ4-7");
    myinit ();
    auxKeyFunc (AUX_LEFT, shoulderSubtract);
    auxKeyFunc (AUX_RIGHT, shoulderAdd);
    auxKeyFunc (AUX_UP, elbowAdd);
    auxKeyFunc (AUX_DOWN, elbowSubtract);
	auxKeyFunc (AUX_1, finger1Subtract);
	auxKeyFunc (AUX_2, finger1Add);

    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
