#include <windows.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glaux.h> 

void CALLBACK display(void)
{
    GLdouble eqn[4] = {0.0, 1.0, 0.0, 0.0};    /* y <0  */
    GLdouble eqn2[4] = {1.0, 0.0, 0.0, 0.0};   /* x <0  */ 
    glClear(GL_COLOR_BUFFER_BIT); 
    glColor3f (0.0, 0.0, 0.0);
    glPushMatrix();
    glTranslatef (0.0, 0.0, -5.0);
	glClipPlane (GL_CLIP_PLANE0, eqn);
    glEnable (GL_CLIP_PLANE0);
    glClipPlane (GL_CLIP_PLANE1, eqn2);
    glEnable (GL_CLIP_PLANE1); 
    glRotatef (90.0, 1.0, 0.0, 0.0);
    auxWireSphere(2.0);
    glPopMatrix();
    glFlush();
} 

void myinit (void) 
{
	glClearColor(192.0/255.0, 192.0/255.0, 192.0/255.0, 1.0);
    glShadeModel (GL_FLAT);
} 

void CALLBACK myReshape(GLsizei w, GLsizei h)
{
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 20.0);
    glMatrixMode(GL_MODELVIEW);
}

int main(int argc, char** argv)
{
    auxInitDisplayMode (AUX_SINGLE | AUX_RGBA);
    auxInitPosition (0, 0, 300, 300);
    auxInitWindow ("ָ4-5");
    myinit ();
    auxReshapeFunc (myReshape);
    auxMainLoop(display);
	return 0;
}
