;file name  ex9-3.ASM for 8e8 LED Display
;*******************************************
PORT1   REG     P1
PORT2   REG     P2
        ORG     0H
START:  JMP     MAIN
        ORG     0BH
        JMP     SWEEP
        ORG     30H
MAIN:
        MOV     SP,#5FH
        MOV     PORT1,#00H
        MOV     PORT2,#0FFH
        MOV     TMOD,#00010001B
        MOV     TH0,#>(65536-1000)
        MOV     TL0,#<(65536-1000)
        CALL    LOAD
        SETB    RS0
        MOV     R4,#BUFFER
        MOV     R0,#BUFFER
        MOV     A,@R0
        MOV     R3,A
        MOV     R1,#00H
        MOV     R2,#00000001H
        CLR     RS0
        MOV     IE,#10000010B
        SETB    TR0
LOOP1:  CALL    DELAY1S
        MOV     R2,#8
        MOV     R0,#BUFFER
NEXT1:  MOV     A,@R0
        RL      A
        MOV     @R0,A
        INC     R0
        DJNZ    R2,NEXT1
        JMP     LOOP1
DELAY1S:        MOV     R5,#08H
$2:     CALL    DELAY
        DJNZ    R5,$2
        RET
DELAY:  MOV     R7,#0
$1:     MOV     R6,#0
        DJNZ    R6.$
        DJNZ    R7,$1
        RET
SWEEP:  PUSH    PSW
        PUSH    A
        MOV     TH0,#>(65536-1000)
        MOV     TL0,#<(65536-1000)
        SETB    RS0
        MOV     PORT1,#00H
        MOV     PORT2,R3
        MOV     PORT1,R2
        MOV     A,R2
        RL      A
        MOV     R2,A
        INC     R1
        CJNE    R1,#8H,SW1
        MOV     R1,#0
        MOV     R0.R4
SW1:    MOV     A,R0
        INC     A
        MOV     R0,A
        MOV     A,@R0
        MOV     R3,A
        POP     A
        POP     PSW
        RETI
LOAD:   MOV     DPTR,#TABLE
        MOV     R1,#8
        MOV     R0,#TABLE
LOAD2:  CLR     A
        MOVC    A,@DPTR
        MOV     @R0,A
        INC     R0
        INC     DPTR
        DJNZ    R1,LOAD1
        RET
TABLE:  DB      3EH,7FH,41H,41H
        DB      4EH,7FH,3EH,00H
        END
