;file name = ex8-7.asm for multi-8255 application
;************************************************************
;
PORTA_I         EQU     6100H
PORTB_I         EQU     6101H
PORTC_I         EQU     6102H
CTL_I           EQU     6103H
PORTA_II        EQU     6200H
PORTB_II        EQU     6201H
PORTC_II        EQU     6202H
CTL_II          EQU     6203H
;
OUTPUT  MACRO   IO_ADDRESS
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#IO_ADDRESS
        MOVX    @DPTR,A
        POP     DPH
        POP     DPL
        ENDM
;
INPUT   MACRO   IO_ADDRESS
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#IO_ADDRESS
        MOVX    A,@DPTR
        POP     DPH
        POP     DPL
        ENDM
;
        ORG     00H
        JMP     MAIN
        ORG     30H
MAIN:
        CALL   DELAY
        CALL   DELAY
        MOV     SP,#5FH
        MOV     A,#80H
        OUTPUT  CTL_I
        OUTPUT  CTL_II
        MOV     A,#0FFH
        OUTPUT  PORTA_I
        MOV     A,#00H
        OUTPUT  PORTC_I
;
GREEN:
        MOV     R0,#08H
        MOV     R2,#11111110B
GREEN1:
        MOV     R1,#08H
        MOV     R3,#00000001B
GREEN2:
        MOV     A,R2
        OUTPUT  PORTA_I
        MOV     A,R3
        OUTPUT  PORTC_I
        RL      A
        MOV     R3,A
        CALL    DELAY
        CALL    DELAY
        MOV     A,#0FFH
        OUTPUT  PORTA_I
        MOV     A,#00H
        OUTPUT  PORTC_I
        CALL    DELAY
        DJNZ    R1,GREEN2
        MOV     A,R2
        RL      A
        MOV     R2,A
        DJNZ    R0,GREEN1
;
RED:
        MOV     R0,#08H
        MOV     R2,#11111110B
RED1:
        MOV     R1,#08H
        MOV     R3,#00000001B
RED2:
        MOV     A,R2
        OUTPUT  PORTA_I
        MOV     A,R3
        OUTPUT  PORTA_II
        RL      A
        MOV     R3,A
        CALL    DELAY
        CALL    DELAY
        MOV     A,#0FFH
        OUTPUT  PORTA_I
        MOV     A,#00H
        OUTPUT  PORTA_II
        CALL    DELAY
        DJNZ    R1,RED2
        MOV     A,R2
        RL      A
        MOV     R2,A
        DJNZ    R0,RED1
;
ORANGE:
        MOV     R0,#08H
        MOV     R2,#11111110B
ORANGE1:
        MOV     R1,#08H
        MOV     R3,#00000001B
ORANGE2:
        MOV     A,R2
        OUTPUT  PORTA_I
        MOV     A,R3
        OUTPUT  PORTC_I
        OUTPUT  PORTA_II
        RL      A
        MOV     R3,A
        CALL    DELAY
        CALL    DELAY
        MOV     A,#0FFH
        OUTPUT  PORTA_I
        MOV     A,#00H
        OUTPUT  PORTC_I
        OUTPUT  PORTA_II
        CALL    DELAY
        DJNZ    R1,ORANGE2
        MOV     A,R2
        RL      A
        MOV     R2,A
        DJNZ    R0,ORANGE1
        JMP     GREEN
;
DELAY   MOV     R6,#00H
DL      MOV     R7,#00H
        DJNZ    R7,$
        DJNZ    R6,DL
        RET
        END
