;file name:ex7-8.ASM for 8051 serier port receiver/tranfor
;******************************************************
PORT1   REG     P1
PORT2   REG     P2
        ORG     0H
START:  JMP     MAIN
        ORG     30H
MAIN:   MOV     SP,#5FH
        MOV     PORT2,#0FFH
        MOV     TMOD,#20H
        MOV     TH1,#0E8H
        SETB    TR1
        MOV     SCON,#01010000B
WAIT:   JNB     RI,KEYPRE
        CLR     RI
        MOV     A,SBUF
        ANL     A,#0FH
        CALL    CHANG
        MOV     PORT2,A
        JMP     WAIT
KEYPRE: CALL    KEYCHK
        JC      WAIT    ;NO KEYPRESS
        SUB     A,#10
        JNC     WAIT    ;OVER 9
        MOV     A,B
        ADD     A,#30H  ;ASCII CODE
        JNB     TI,$
        CLR     TI
        MOV     SUBF,A
        JMP     WAIT
KEYCHK: MOV     R0,#4
        MOV     R1,#11101111B
        MOV     R2,#11111111B
NLINE:  MOV     A,R1
        MOV     PORT1,A
        MOV     A,PORT1
        ORL     A,#0F0H
        CJNE    A,#0FFH,KEYIN
        MOV     A,R1
        RL      A
        MOV     R1,A
        DJNZ    R0,NLINE
        SETB    C
        JMP     KEYEXIT
KEYIN:  MOV     R2,A
        CALL    DELAY1
NOPEN:  MOV     A,PORT1
        ORL     A,#0F0H
        CJNE    A,#0FFH,NOPEN
        CALL    DELAY1
        CALL    TRANF
        CLR      C
        RET
DELAY1: MOV     R7,#30
        MOV     R6,#0
$1:     DJNZ    R6,$
        DJNZ    R7,$1
        RET
TARNF:  MOV     B,#0
        MOV     A,R1
C1:     RRC     A
        JNC     C2
        INC     B
        INC     B
        INC     B
        INC     B
        JMP     C1
C2:     MOV     A,R2
        RR      A
        RR      A
        RR      A
        RR      A
C3:     RRC     A
        JNC     C4
        INC     B
        JMP     C3
C4:     MOV     A,B
        RET
CHANG:  INC     A
        MOVC    A,@A+PC
        RET
        DB      0C0H,0F9H,0A4H,0B0H
        DB      99H,92H,82H,83H
        DB      80H,90H,88H,83H
        DB      0C6H,0A1H,86H,8EH
        END
