file name=RTC1.asm for Real time Display
;****************************************************
;
;wqLCMO}`ƭ
WR_COM_PORT     EQU     6000H   ;WRITE LCD COMMAND PORT
RD_STATUS_PORT  EQU     6001H   ;READ LCD STATUS PORT
WR_DATA_PORT    EQU     6002H   ;WRITE LCD DATA PORT
RD_DATA_PORT    EQU     6003H   ;READ LCD DATA PORT
;CONTA00        EQU     3FF8H   ;Conyrol address
SEC     EQU     3FF9H   ;Second
MIN     EQU     3FFAH   ;minutes
;
;wq
OUTPUT  MACRO   IO_ADDRESS      ;wqX
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#IO_ADDRESS
        MOVX    @DPTR,A
        POP     DPH
        POP     DPL
        ENDM
;
INPUT   MACRO   IO_ADDRESS      ;wqJ
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#IO_ADDRESS
        MOVX    A,@DPTR
        POP     DPH
        POP     DPL
        ENDM
;
        ORG     0H
        JMP     MAIN
        ORG     30H
MAIN:
        ACALL   INIT
        ACALL   CLEAR
LOOP:   ACALL   TIME
        ACALL   DELAY
        JMP     LOOP
;
INIT:
;       ACALL   DELAY
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
;
        MOV     A,#08H
        ACALL   WRCOM
        ;
        MOV     A,#01H
        ACALL   WRCOM
;
        MOV     A,#06H
        ACALL   WRCOM
;
        MOV     A,#0CH
        ACALL   WRCOM
        RET
;
CLEAR:
        MOV     A,#80H
        OUTPUT  CONTADD ;]wigJ
        MOV     A,#0H
        OUTPUT  SEC     ;M
        OUTPUT  MIN     ;M
        OUTPUT  CONTADD ;MigJ
        MOV     R6,#0H
        MOV     R7,#0H
        RET
TIME:
        MOV     A,40H
        OUTPUT  CONTADD ;]wiŪ
$1:     INTPUT  SEC     ;Ū
        CJNE    A,06,$2 ;L
        JMP     $1
$2:     MOV     R6,A    ;
        INTPUT  MIN
        MOV     R7,A    ;
        MOV     A,#0H   ;MiŪ
        OUTPUT  CONTADD ;MiŪ
        RETI
DISPLAY:
        ACALL   FIRST
        MOV     R7,A
        ACALL   CHANG
        ACALL   DSP
        ACALL   SECOND
        MOV     A,R6
        ACALL   CHANG
        ACALL   DSP
        RET
;
CHANG:
        MOV     R1,A
        ANL     A,#F0H
        SWAP    A
        ADD     A,#30H
        MOV     R0,A
        MOV     A,R1
        ANL     A,#F0H
        ADD     A,#30H
        MOV     R1,A
        RET

DSP:
        MOV     A,RO
        ACALL   WRDATA
        MOV     A,R1
        ACALL   WRDATA
        RET
;
FIRST:
        MOV     A,#85H
        ACALL   WRCOM
        RET
;
SECOND:
        MOV     A,#88H
        ACALL   WRCOM
        RET
;
WRCOM:
        ACALL   BUSY
        OUTPUT  WR_COM_PORT
        RET
;
WRDATA:
        ACALL   BUSY
        OUTPUT  WR_DATA_PORT
        RET
;
BUSY:
        PUSH    A
WAIT:
        INPUT   RD_STATUS_PORT
        JB      ACC.7,WAIT
        POP     A
        RET
        END
