file name=LCDext.asm for LIQUID CRYSTAL DISPLAY
;****************************************************
;
WR_COM_PORT     EQU     6000H   ;WRITE LCD COMMAND PORT
RD_STATUS_PORT  EQU     6001H   ;READ LCD STATUS PORT
WR_DATA_PORT    EQU     6002H   ;WRITE LCD DATA PORT
RD_DATA_PORT    EQU     6003H   ;READ LCD DATA PORT
;
;wq
OUTPUT  MACRO   IO_ADDRESS      ;wqX
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#IO_ADDRESS
        MOVX    @DPTR,A
        POP     DPH
        POP     DPL
        ENDM
;
INPUT   MACRO   IO_ADDRESS      ;wqJ
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#IO_ADDRESS
        MOVX    A,@DPTR
        POP     DPH
        POP     DPL
        ENDM
;
        ORG     0H
        JMP     MAIN
        ORG     30H
MAIN:
        ACALL   INIT
        ACALL   FIRST
        MOV     DPTR,#TABLE1
        ACALL   DISPLAY
        ACALL   SECOND
        MOV     DPTR,#TABLE2
        ACALL   DISPLAY
        JMP     $
;
INIT:
;       ACALL   DELAY
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
;
        MOV     A,#08H
        ACALL   WRCOM
        ;
        MOV     A,#01H
        ACALL   WRCOM
;
        MOV     A,#06H
        ACALL   WRCOM
;
        MOV     A,#0CH
        ACALL   WRCOM
        RET
;
DISPLAY:
        MOV     R1,#00H
NEXT:   MOV     A,R1
        MOVC    A,@A+DPTR
        CJNE    A,#23H,DSP
        RET
DSP:    ACALL   WRDATA
        INC     R1
        AJMP    NEXT
FIRST:
        MOV     A,#80H
        ACALL   WRCOM
        RET
;
SECOND:
        MOV     A,#0C0H
        ACALL   WRCOM
        RET
;
WRCOM:
        ACALL   BUSY
        OUTPUT  WR_COM_PORT
        RET
;
WRDATA:
        ACALL   BUSY
        OUTPUT  WR_DATA_PORT
        RET
;
BUSY:
        PUSH    A
WAIT:
        INPUT   RD_STATUS_PORT
        JB      ACC.7,WAIT
        POP     A
        RET
;
DELAY:
        SETB    RS0
        MOV     R3,#00H
DLY:    MOV     R4,#00H
        DJNZ    R4,$
        DJNZ    R3,DLY
        CLR     RS0
        RET
TABLE1  DB      LCD Char Display.
        DB      #
TABLE2  DB      I am 851234K.
        DB      #
        END
