;file name=ex10-4.asm for LCD exercise
;***********************************************
        ORG     00H
        AJMP    MAIN
        ORG     30H
MAIN:
        MOV     SP,#5FH
        ACALL   INIT
        ACALL   PATTERN
        ACALL   FIRST
        MOV     DPTR,#TABLE
        ACALL   DISPLAY
        JMP     $
;
INIT:
        ACALL   DELAY
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
;
        MOV     A,#08H
        ACALL   WRCOM
;
        MOV     A,#01H
        ACALL   WRCOM
;
        MOV     A,#06H
        ACALL   WRCOM
;
        MOV     A,#0CH
        ACALL   WRCOM
        RET
;
PATTERN:
        MOV     A,#40H
        ACALL   WRCOM
        MOV     R2,#48
        MOV     DPTR,#WORD
        MOV     R3,#0
NEXTP:
        MOV     A,R3
        MOVC    A,@A+DPTR
        ACALL   WRDATA
        INC     R3
        DJNZ    R2,NEXTP
        RET
DISPLAY:
        MOV     R1,#00H
NEXTD:
        MOV     A,R1
        MOVC    A,@A+DPTR
        CJNE    A,#23H,DSP
        RET
DSP:
        ACALL   WRDATA
        INC     R1
        AJMP    NEXTD
FIRST:
        MOV     A,#10000000B
        ACALL   WRCOM
        RET
;
WRCOM:
        MOV     P2,#11111000B
        NOP
        SETB    P2.2
        MOV     P0,A
        NOP
        CLR     P2.2
        CALL    DELAY
        RET
WRDATA:
        MOV     P2,#11111001B
        NOP
        SETB    P2.2
        MOV     P0,A
        NOP
        CLR     P2.2
        CALL    DELAY
        RET
DELAY:
        MOV     R6,#80H
DL1:    MOV     R7,#80H
        DJNZ    R7,$
        DJNZ    R6,DL1
        RET
WORD    DB      04H,0CH,12H,0DH,1EH,04H,08H,00H
        DB      0EH,04H,1FH,04H,04H,0AH,11H,00H
        DB      0EH,0EH,0EH,1FH,04H,0EH,17H,00H
        DB      10H,1FH,02H,0FH,0AH,1FH,02H,00H
        DB      0FH,09H,0FH,09H,0FH,09H,13H,00H
        DB      0FH,09H,09H,0FH,09H,09H,0FH,00H
TABLE   DB      00H,01H,02H,'2000',03H,'1',04H,'1',05H
                "#"
        END
