;file name=ex10-3.asm for LCD exercise
;***********************************************
        ORG     00H
        AJMP    MAIN
        ORG     30H
MAIN:
        MOV     SP,#5FH
        ACALL   INIT
        ACALL   FIRST
        MOV     DPTR,#TABLE1
        ACALL   DISPLAY
        ACALL   SECOND
        MOV     DPTR,#TABLE2
        ACALL   DISPLAY
        JMP     $
;
INIT:
        ACALL   DELAY
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
        MOV     A,#38H
        ACALL   WRCOM
;
        MOV     A,#08H
        ACALL   WRCOM
;
        MOV     A,#01H
        ACALL   WRCOM
;
        MOV     A,#06H
        ACALL   WRCOM
;
        MOV     A,#0CH
        ACALL   WRCOM
        RET
;
DISPLAY:
        MOV     R1,#00H
NEXT:
        MOV     A,R1
        MOVC    A,@A+DPTR
        CJNE    A,#23H,DSP
        RET
DSP:
        ACALL   WRDATA
        INC     R1
        AJMP    NEXT
FIRST:
        MOV     A,#10000000B
        ACALL   WRCOM
        RET
;
SECOND:
        MOV     A,#11000000B
        ACALL   WRCOM
        RET
;
WRCOM:
        ACALL   BUSY
        MOV     P2,#11111000B
        NOP
        SETB    P2.2
        MOV     P0,A
        NOP
        CLR     P2.2
        RET
WRDATA:
        ACALL   BUSY
        MOV     P2,#11111001B
        NOP
        SETB    P2.2
        MOV     P0,A
        NOP
        CLR     P2.2
        RET
BUSY:
        PUSH    ACC
WAIT:
        MOV     P2,#11111010B
        NOP
        SETB    P2.2
        MOV     A,P0
        JB      ACC.7,WAIT
        CLR     P2.2
        POP     ACC
        RET
DELAY:
        MOV     R6,#80H
DL1:    MOV     R7,#80H
        DJNZ    R7,$
        DJNZ    R6,DL1
        RET
TABLE1  DB      "LCD Char Display."
        DB      "#"
TABLE2  DB      "I am 891234..."
        DB      "#"
        END
