;:SYSTEM_8.H
;RS_LCD  .REG    P3.3
;RW_LCD  .REG    P3.4
;E_LCD   .REG    P3.5
;BUS_LCD .REG    P1
;--------------------------------------------------------------------
CHKBUSY_LCD                     ; LCD æµ
        PUSH    ACC
        SETB    BUS_LCD.7
CHK_$   CLR     RS_LCD
        SETB    RW_LCD
        SETB    E_LCD
        NOP
        MOV     A,BUS_LCD
        CLR     E_LCD
        JB      ACC.7,CHK_$     ;æµλԪ
        POP     ACC
        RET
;--------------------------------------------------------------------
COMMAND_LCD                     ;д LCD
        CALL    CHKBUSY_LCD     ;æµ
        MOV     BUS_LCD,A
        CLR     RS_LCD
        CLR     RW_LCD
        SETB    E_LCD
        NOP
        CLR     E_LCD
        RET
;--------------------------------------------------------------------
WRITE_LCD                       ;дԪ LCD
        CALL    CHKBUSY_LCD     ;æµ
        MOV     BUS_LCD,A
        SETB    RS_LCD
        CLR     RW_LCD
        SETB    E_LCD
        NOP
        CLR     E_LCD
        RET
;--------------------------------------------------------------------
READ_LCD                        ;ȡ LCD 
        MOV     BUS_LCD,#FFH
        CALL    CHKBUSY_LCD     ;ȼ LCD æµ
        SETB    RS_LCD
        SETB    RW_LCD
        SETB    E_LCD
        NOP
        MOV     A,BUS_LCD
        CLR     E_LCD
        RET
;--------------------------------------------------------------------
INITIAL_LCD                     ;ִ LCD ʼ
        PUSH    ACC
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#0DH          ;ʾƣα겻ʾֻ˸
        CALL    COMMAND_LCD
        MOV     A,#01H          ;ʾ
        CALL    COMMAND_LCD
        MOV     A,#06H          ;ģʽ趨
        CALL    COMMAND_LCD
        POP     ACC
        RET
;--------------------------------------------------------------------
CLEAR_LCD                       ; LCD ʾ
        PUSH    ACC
        MOV     A,#01H          ;ʾ
        CALL    COMMAND_LCD
        POP     ACC
        RET
;--------------------------------------------------------------------
HEX_LCD                         ; ACC ,ʮֵʾ
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC

        PUSH    ACC
        SWAP    A               ;ߵλԪ
        ANL     A,#0FH          ;µλԪ
        MOV     DPTR,#ASCII_CODE ;DPTR ָ ASCII_CODE
        MOVC    A,@A+DPTR       ;ȡ ASCII 
        CALL    WRITE_LCD       ;д LCD
        POP     ACC
        ANL     A,#0FH          ;µλԪ
        MOVC    A,@A+DPTR       ;ȡ ASCII 
        CALL    WRITE_LCD       ;д LCD

        POP     ACC
        POP     DPL
        POP     DPH
        RET
ASCII_CODE      .DB     '0123456789ABCDEF'
;--------------------------------------------------------------------
DEC_LCD                         ; ACC ,ʮֵʾ
        PUSH    DPH             ; XXH -> XXXD
        PUSH    DPL
        PUSH    ACC
        PUSH    B
        PUSH    PSW

        MOV     B,#100
        DIV     AB              ;ȡðλ DPH
        MOV     DPH,A

        MOV     A,B
        MOV     B,#10
        DIV     AB              ;ȡʮλ DPL
        MOV     DPL,A           ;ȡøλ B

        MOV     A,DPH
        CJNE    A,#00,$LKKK     ;λΪ 0, ʾ
        JMP     $NKKK
$LKKK   ADD     A,#30H
        CALL    WRITE_LCD       ;λд LCD
$NKKK
        MOV     A,DPL
        ADD     A,#30H
        CALL    WRITE_LCD       ;ʮλд LCD

        MOV     A,B
        ADD     A,#30H
        CALL    WRITE_LCD       ;λд LCD

        POP     PSW
        POP     B
        POP     ACC
        POP     DPL
        POP     DPH
        RET
;--------------------------------------------------------------------
BIN_LCD PUSH    PSW             ; ACC ,Զֵʾ
        PUSH    ACC
        PUSH    B

        MOV     B,#8            ;ܹ 8 λԪ
AGAIN$  RLC     ACC
        PUSH    ACC
        JC      ONE$            ; C=1  ONE
        MOV     A,#30H
        CALL    WRITE_LCD       ;ʾ "0"
        JMP     NEXT$
ONE$    MOV     A,#31H
        CALL    WRITE_LCD       ;ʾ "1"
NEXT$   POP     ACC
        DJNZ    B,AGAIN$        ;8 λԪǷ?

        POP     B
        POP     ACC
        POP     PSW
        RET
;--------------------------------------------------------------------
STRING_LCD                      ;ӡִ LCD, DPTR ı,
        PUSH    DPH             ;ִΪ 65536 .
        PUSH    DPL
        PUSH    ACC
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        INC     DPTR            ;ָһλַ
        JMP     LOOP$
OVER$   POP     ACC
        POP     DPL
        POP     DPH
        RET
;--------------------------------------------------------------------
STRING_LCD_                     ;ӡִ LCD, DPTR ı,
        PUSH    ACC             ;ִΪ 65536 
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        INC     DPTR            ;ָһλַ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        JMP     LOOP$
OVER$   POP     ACC
        RET
;--------------------------------------------------------------------
STRING1_LCD                     ;ӡִ LCD,(COUNT,'STRING')
        PUSH    B               ;DPTR ı, ִΪ 256 .
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC

        MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾ
        MOV     B,A
        INC     DPTR            ;ָһҪʾԪλַ
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CALL    WRITE_LCD
        INC     DPTR            ;ָһλַ
        DJNZ    B,LOOP$

        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        RET
;--------------------------------------------------------------------
STRING1_LCD_                    ;ӡִ LCD,(COUNT,'STRING'),
        PUSH    B               ;DPTR ı, ִΪ 256 .
        PUSH    ACC

        MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾ
        MOV     B,A
        INC     DPTR            ;ָһҪʾԪλַ
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CALL    WRITE_LCD
        INC     DPTR            ;ָһλַ
        DJNZ    B,LOOP$

        POP     ACC
        POP     B
        RET
;--------------------------------------------------------------------
STRING2_LCD                     ;ӡִ LCD, DPTR ı,
        PUSH    B               ;ִΪ 256 .
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     B,#00H
LOOP$   MOV     A,B
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        INC     B               ;ָһλַ
        JMP     LOOP$
OVER$   POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        RET
;--------------------------------------------------------------------
STRING2_LCD_                    ;ӡִ LCD, DPTR ı,
        PUSH    B               ;ִΪ 256 .
        PUSH    ACC
        MOV     B,#00H
LOOP$   MOV     A,B
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        INC     B               ;ָһλַ
        JMP     LOOP$
OVER$   POP     ACC
        POP     B
        RET
;---------------------------------------------------------------
INITIAL_8279                    ;ִ 8279 ʼ
        PUSH    ACC
        PUSH    DPH
        MOV     DPH,#W_C_8279
        MOV     A,#11H          ;ұ߽ʾģʽ
        MOVX    @DPTR,A         ;ʽ
        MOV     A,#34H          ;ʱ滮PPPPP=20100KHz
        MOVX    @DPTR,A
        MOV     A,#D3H          ;ʾ
        MOVX    @DPTR,A
        POP     DPH
        POP     ACC
        RET
