;:RTC_INT.ASM
        .INCLUDE MACRO.H
        .INCLUDE MACRO2.H
        .INCLUDE DS87C530.H
BEEP_PIN         .REG  P3.1
SECOND_BUFFER    .EQU  51H      ;뻺
MINUTE_BUFFER    .EQU  52H      ;ֻ
HOUR_BUFFER      .EQU  53H      ;ʱ
;==================================================================
        .ORG    00H
        JMP     START
        .ORG    6BH             ;RTCж
        JMP     RTC_INT
START   MOV     SP,#60H         ;趨ѵ
        CALL    INITIAL_LCD     ;LCDʼ
        MOV     TA,#AAH         ;ʱȡ
        MOV     TA,#55H         ;
        MOV     RTCC,#00000101B ;RTCWE=1,д;RTCE=1,RTC
        DELAY   #1,#1           ;ȴ4е
        MOV     RTCS,#55        ;趨55
        MOV     RTCM,#59        ;趨59
        MOV     RTCH,#10        ;趨10ʱ
        MOV     TA,#AAH         ;ʱȡ
        MOV     TA,#55H         ;
        MOV     RTCC,#00000001B ;RTCWE=0,д;RTCE=1,RTC
;------------------------------------------------------------------
        CLR     ERTCI           ;EIE.5=ERTCI=0,RTCжϳ
        ANL     RTCC,#00001111B ;,,,ʱȽϹܹص
        MOV     RTASS,#00       ;趨00
        MOV     RTAS,#00        ;趨00
        MOV     RTAM,#00        ;趨00
        MOV     RTAH,#11        ;趨11ʱ
        ORL     RTCC,#11110000B ;,,,ʱȽϹܴ
        SETB    ERTCI           ;EIE.5=ERTCI=1,RTCж
        SETB    EA              ;еж
;------------------------------------------------------------------
READTIME XY_LCD 1,0             ;LCDαƵһеһλ
        ORL     RTCC,#11111001B ;RTCRE=1,ȡ
        DELAY   #1,#1           ;ȴ4е
        MOV     SECOND_BUFFER,RTCS      ;ȡ
        MOV     MINUTE_BUFFER,RTCM      ;ȡ
        MOV     HOUR_BUFFER,RTCH        ;ȡʱ
        ANL     RTCC,#11110001B ;RTCRE=0,ȡ

        MOV     A,HOUR_BUFFER   ;ʾʱ
        CALL    DEC_LCD         ;ACC,ʮֵʾ
        PRINTF_LCD (":")        ;ʾ:
        MOV     A,MINUTE_BUFFER ;ʾ
        CALL    DEC_LCD         ;ACC,ʮֵʾ
        PRINTF_LCD (":")        ;ʾ:
        MOV     A,SECOND_BUFFER ;ʾ
        CALL    DEC_LCD         ;ACC,ʮֵʾ

        DELAY   #00H,#00H       ;ӳһ
        JMP     READTIME        ;¶ȡʱ
;------------------------------------------------------------------
RTC_INT ANL     RTCC,#11111101B ;RTCIF=0,RTCж

        MOV     R5,#100         ;50
BEEP$   CPL     BEEP_PIN
        DELAY   #12,#20
        DJNZ    R5,BEEP$

        CLR     ERTCI           ;EIE.5=ERTCI=0,RTCжϳ
        ANL     RTCC,#00001111B ;,,,ʱȽϹܹص
        MOV     RTASS,#00       ;趨00
        MOV     RTAS,#05        ;趨05
        MOV     RTAM,#00        ;趨00
        MOV     RTAH,#11        ;趨11ʱ
        ORL     RTCC,#11110000B ;,,,ʱȽϹܴ
        SETB    ERTCI           ;EIE.5=ERTCI=1,RTCж
        RETI
;------------------------------------------------------------------
        .INCLUDE SYSTEM.H
        .END
