;:DS87C530.H
;=======================================================
;PRE-DEFINE DS87C530 SPECIAL FUNCTION REGISTER ADDRESSES
;=======================================================
.CHIP   8052
DPL1    .REG    84H     ;Data Pointer Low1
DPH1    .REG    85H     ;Data Pointer High1
DPS     .REG    86H     ;Data Pointer Select
CKCON   .REG    8EH     ;Clock Control
EXIF    .REG    91H     ;External Interrupt Flag
TRIM    .REG    96H     ;RTC Trim
SCON0   .REG    98H
SBUF0   .REG    99H
SADDR0  .REG    A9H     ;Slave Address Zero
SADDR1  .REG    AAH     ;Slave Address One
SADEN0  .REG    B9H     ;Slave Address Mask Enable Zero
SADEN1  .REG    BAH     ;Slave Address Mask Enable One
SCON1   .REG    C0H     ;Serial Port Control One
SBUF1   .REG    C1H     ;Serial Data Buffer One
ROMSIZE .REG    C2H     ;ROM Size Select Register
PMR     .REG    C4H     ;Power Management Register
STATUS  .REG    C5H     ;Power Management Mode Status
TA      .REG    C7H     ;Timed Access
T2MOD   .REG    C9H     ;Timer Two Mode Control
WDCON   .REG    D8H     ;Watchdog Control
EIE     .REG    E8H     ;Extended Interrupt Enable
RTASS   .REG    F2H     ;RTC Alarm Sub-Seconds
RTAS    .REG    F3H     ;RTC Alarm Seconds
RTAM    .REG    F4H     ;RTC Alarm Minutes
RTAH    .REG    F5H     ;RTC Alarm Hours
EIP     .REG    F8H     ;Extended Interrupt Priority
RTCC    .REG    F9H     ;RTC Control
RTCSS   .REG    FAH     ;RTC Sub-Seconds
RTCS    .REG    FBH     ;RTC Seconds
RTCM    .REG    FCH     ;RTC Minutes
RTCH    .REG    FDH     ;RTC Hours
RTCD0   .REG    FEH     ;RTC Calendar 0
RTCD1   .REG    FFH     ;RTC Calendar 1

;=======================================================
;PRE-DEFINE DS87C530 SPECIAL FUNCTION BIT ADDRESSES
;=======================================================
;-----------  P1   -------------------------------------
RXD1    .REG    90H.2
TXD1    .REG    90H.3
INT2    .REG    90H.4
INT3\   .REG    90H.5
INT4    .REG    90H.6
INT5\   .REG    90H.7

;-----------  SCON0-------------------------------------
RI_0    .REG    98H.0
TI_0    .REG    98H.1
RB8_0   .REG    98H.2
TB8_0   .REG    98H.3
REN_0   .REG    98H.4
SM2_0   .REG    98H.5
SM1_0   .REG    98H.6
SM0_0   .REG    98H.7

;-----------  IE   -------------------------------------
ES0     .REG    A8H.4
ES1     .REG    A8H.6   ;Enable Serial Port 1 Interrupt

;-----------  P3   -------------------------------------
RXD0    .REG    B0H.0
TXD0    .REG    B0H.1

;-----------  IP   -------------------------------------
PS0     .REG    B8H.4
PS1     .REG    B8H.6   ;Serial Port 1

;-----------  SCON1-------------------------------------
RI_1    .REG    C0H.0   ;Serial Port 1 Receive Int. Flag
TI_1    .REG    C0H.1   ;Serial Port 1 Transmit Int. Flag
RB8_1   .REG    C0H.2   ;Serial Port 1 Receive bit 8
TB8_1   .REG    C0H.3   ;Serial Port 1 Transmit bit 8
REN_1   .REG    C0H.4   ;Serial Port 1 Receiver Enable bit
SM2_1   .REG    C0H.5   ;Serial Port 1 Mode bit2
SM1_1   .REG    C0H.6   ;Serial Port 1 Mode bit1
SM0_1   .REG    C0H.7   ;Serial Port 1 Mode bit0,
                        ;or Framing Error Flag
;-----------  PSW  -------------------------------------
F1      .REG    D0H.1   ;General Purpose Flag

;-----------  WDCON-------------------------------------
RWT     .REG    D8H.0   ;Reset Watchdog Timer
EWT     .REG    D8H.1   ;Enable Watchdog Timer Reset
WTRF    .REG    D8H.2   ;Watchdog Timer Reset Flag
WDIF    .REG    D8H.3   ;Watchdog Interrupt Flag
PFI     .REG    D8H.4   ;Power-Fail Interrupt Flag
EPFI    .REG    D8H.5   ;Enable Power-Fail Interrupt
POR     .REG    D8H.6   ;Power-On Reset
SMOD_1  .REG    D8H.7   ;Serial Modification

;-----------  EIE  -------------------------------------
EX2     .REG    E8H.0   ;Enable External Interrupt 2
EX3     .REG    E8H.1   ;Enable External Interrupt 3
EX4     .REG    E8H.2   ;Enable External Interrupt 4
EX5     .REG    E8H.3   ;Enable External Interrupt 5
EWDI    .REG    E8H.4   ;Enable Watchdog Interrupt
ERTCI   .REG    E8H.5   ;Enable RTC Interruput

;-----------  EIP  -------------------------------------
PX2     .REG    F8H.0   ;External Interrupt 2 Priority
PX3     .REG    F8H.1   ;External Interrupt 3 Priority
PX4     .REG    F8H.2   ;External Interrupt 4 Priority
PX5     .REG    F8H.3   ;External Interrupt 5 Priority
PWDI    .REG    F8H.4   ;Watchdog Timer Interrupt Priority
PRTCI   .REG    F8H.5   ;RTC Interrupt Priority
