;:DS80C310.H
;=======================================================
;PRE-DEFINE DS80C310 SPECIAL FUNCTION REGISTER ADDRESSES
;=======================================================
.CHIP   8052
DPL1    .REG    84H     ;Data Pointer Low1
DPH1    .REG    85H     ;Data Pointer High1
DPS     .REG    86H     ;Data Pointer Select
CKCON   .REG    8EH     ;Clock Control
EXIF    .REG    91H     ;External Interrupt Flag
SADDR0  .REG    A9H     ;Slave Address Zero
SADEN0  .REG    B9H     ;Slave Address Mask Enable Zero
STATUS  .REG    C5H     ;Power Management Mode Status
T2MOD   .REG    C9H     ;Timer Two Mode Control
WDCON   .REG    D8H     ;Watchdog Control
EIE     .REG    E8H     ;Extended Interrupt Enable
EIP     .REG    F8H     ;Extended Interrupt Priority

;=======================================================
;PRE-DEFINE DS80C310 SPECIAL FUNCTION BIT ADDRESSES
;=======================================================
;-----------  P1   -------------------------------------
INT2    .REG    90H.4
INT3\   .REG    90H.5
INT4    .REG    90H.6
INT5\   .REG    90H.7

;-----------  IE   -------------------------------------
ES0     .REG    A8H.4

;-----------  IP   -------------------------------------
PS0     .REG    B8H.4

;-----------  PSW  -------------------------------------
F1      .REG    D0H.1   ;General Purpose Flag

;-----------  WDCON-------------------------------------
POR     .REG    D8H.6   ;Power-On Reset

;-----------  EIE  -------------------------------------
EX2     .REG    E8H.0   ;Enable Extended Interrupt 2
EX3     .REG    E8H.1   ;Enable Extended Interrupt 3
EX4     .REG    E8H.2   ;Enable Extended Interrupt 4
EX5     .REG    E8H.3   ;Enable Extended Interrupt 5

;-----------  EIP  -------------------------------------
PX2     .REG    F8H.0   ;Extended Interrupt 2 Priority
PX3     .REG    F8H.1   ;Extended Interrupt 3 Priority
PX4     .REG    F8H.2   ;Extended Interrupt 4 Priority
PX5     .REG    F8H.3   ;Extended Interrupt 5 Priority
