;:80C251-B.H
;=======================================================
;PRE-DEFINE 80C251 SPECIAL FUNCTION REGISTER ADDRESSES
;=======================================================
.CHIP   8052
DPXL    .REG    84H     ;Data Pointer, Extended Low
WDTRST  .REG    A6H     ;Watchdog Timer Reset
IE0     .REG    A8H     ;Interrupt Enable Control 0
SADDR   .REG    A9H     ;Slave Address
IPH0    .REG    B7H     ;Interrupt Priority Control High 0
IPL0    .REG    B8H     ;Interrupt Priority Control Low 0
SADEN   .REG    B9H     ;Slave Address Mask Enable
SPH     .REG    BEH     ;Stack Pointer High - MSB of SPX
T2MOD   .REG    C9H     ;Timer/Counter 2 Mode Control
PSW1    .REG    D1H     ;Program Status Word 1
CCON    .REG    D8H     ;PCA Timer/Counter Control

CMOD    .REG    D9H     ;PCA Timer/Counter Mode
CCAPM0  .REG    DAH     ;PCA Compare/Capture Module 0 Mode
CCAPM1  .REG    DBH     ;PCA Compare/Capture Module 1 Mode
CCAPM2  .REG    DCH     ;PCA Compare/Capture Module 2 Mode
CCAPM3  .REG    DDH     ;PCA Compare/Capture Module 3 Mode
CCAPM4  .REG    DEH     ;PCA Compare/Capture Module 4 Mode

CL      .REG    E9H     ;PCA Timer/Counter Low Byte
CCAP0L  .REG    EAH     ;PCA Compare/Capture Module 0 Low Byte
CCAP1L  .REG    EBH     ;PCA Compare/Capture Module 1 Low Byte
CCAP2L  .REG    ECH     ;PCA Compare/Capture Module 2 Low Byte
CCAP3L  .REG    EDH     ;PCA Compare/Capture Module 3 Low Byte
CCAP4L  .REG    EEH     ;PCA Compare/Capture Module 4 Low Byte

CH      .REG    F9H     ;PCA Timer/Counter High Byte
CCAP0H  .REG    FAH     ;PCA Compare/Capture Module 0 High Byte
CCAP1H  .REG    FBH     ;PCA Compare/Capture Module 1 High Byte
CCAP2H  .REG    FCH     ;PCA Compare/Capture Module 2 High Byte
CCAP3H  .REG    FDH     ;PCA Compare/Capture Module 3 High Byte
CCAP4H  .REG    FEH     ;PCA Compare/Capture Module 4 High Byte

;=======================================================
;PRE-DEFINE 80C251 SPECIAL FUNCTION BIT ADDRESSES
;=======================================================
;-----------  P1   -------------------------------------
ECI     .REG    90H.2   ;PCA Timer/Counter External Input
CEX0    .REG    90H.3   ;Compare/Capture Module 0 External I/O
CEX1    .REG    90H.4   ;Compare/Capture Module 1 External I/O
CEX2    .REG    90H.5   ;Compare/Capture Module 2 External I/O
CEX3    .REG    90H.6   ;Compare/Capture Module 3 External I/O
CEX4    .REG    90H.7   ;Compare/Capture Module 4 External I/O

;-----------  IE0  -------------------------------------
EC      .REG    A8H.6   ;PCA Interrupt Enable

;-----------  PSW  -------------------------------------
UD      .REG    D0H.1   ;User-defined Flag

;-----------  CCON -------------------------------------
CCF0    .REG    D8H.0   ;PCA Compare/Capture Module 0 Flag
CCF1    .REG    D8H.1   ;PCA Compare/Capture Module 1 Flag
CCF2    .REG    D8H.2   ;PCA Compare/Capture Module 2 Flag
CCF3    .REG    D8H.3   ;PCA Compare/Capture Module 3 Flag
CCF4    .REG    D8H.4   ;PCA Compare/Capture Module 4 Flag
CR      .REG    D8H.6   ;PCA Timer/Counter Run Control Bit
CF      .REG    D8H.7   ;PCA Timer/Counter Overflow Flag
