;:SYSTEM.ASM
        .MODULE CHKBUSY_LCD     ; LCD æµ
        .GLOBAL CHKBUSY_LCD
R_B_LCD .EQU    B2H
CHKBUSY_LCD
        PUSH    DPH
        PUSH    ACC
        MOV     DPH,#R_B_LCD
CHK_$   MOVX    A,@DPTR
        JB      ACC.7,CHK_$     ;æµλԪ
        POP     ACC
        POP     DPH
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE COMMAND_LCD     ;д LCD
        .GLOBAL COMMAND_LCD
        .EXTERN CHKBUSY_LCD
W_C_LCD .EQU    B0H
COMMAND_LCD
        PUSH    DPH
        CALL    CHKBUSY_LCD     ;æµ
        MOV     DPH,#W_C_LCD
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE INITIAL_LCD     ;ִ LCD ʼ
        .GLOBAL INITIAL_LCD
        .EXTERN COMMAND_LCD
INITIAL_LCD
        PUSH    ACC
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#38H          ;趨
        CALL    COMMAND_LCD
        MOV     A,#0DH          ;ʾƣα겻ʾ
        CALL    COMMAND_LCD     ;ֻ˸
        MOV     A,#01H          ;ʾ
        CALL    COMMAND_LCD
        MOV     A,#06H          ;ģʽ趨
        CALL    COMMAND_LCD
        POP     ACC
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE WRITE_LCD       ;дԪ LCD
        .GLOBAL WRITE_LCD
        .EXTERN CHKBUSY_LCD
W_D_LCD .EQU    B1H
WRITE_LCD
        PUSH    DPH
        CALL    CHKBUSY_LCD     ;æµ
        MOV     DPH,#W_D_LCD
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE READ_LCD        ;ȡ LCD 
        .GLOBAL READ_LCD
        .EXTERN CHKBUSY_LCD
R_D_LCD .EQU    B3H
READ_LCD
        PUSH    DPH
        CALL    CHKBUSY_LCD     ;ȼ LCD æµ
        MOV     DPH,#R_D_LCD
        MOVX    A,@DPTR
        POP     DPH
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE CLEAR_LCD       ; LCD ʾĻ
        .GLOBAL CLEAR_LCD
        .EXTERN COMMAND_LCD
CLEAR_LCD
        PUSH    ACC
        MOV     A,#01H          ;ʾ
        CALL    COMMAND_LCD
        POP     ACC
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE HEX_LCD         ; ACC ,ʮֵʾ
        .GLOBAL HEX_LCD
        .EXTERN WRITE_LCD
HEX_LCD
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC

        PUSH    ACC
        SWAP    A               ;ߵλԪ
        ANL     A,#0FH          ;µλԪ
        MOV     DPTR,#ASCII_CODE ;DPTR ָ ASCII_CODE
        MOVC    A,@A+DPTR       ;ȡ ASCII 
        CALL    WRITE_LCD       ;д LCD
        POP     ACC
        ANL     A,#0FH          ;µλԪ
        MOVC    A,@A+DPTR       ;ȡ ASCII 
        CALL    WRITE_LCD       ;д LCD

        POP     ACC
        POP     DPL
        POP     DPH
        RET
ASCII_CODE      .DB     '0123456789ABCDEF'
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE DEC_LCD         ; ACC ,ʮֵʾ
        .GLOBAL DEC_LCD         ; XXH -> XXXD
        .EXTERN WRITE_LCD
DEC_LCD
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        PUSH    B
        PUSH    PSW

        MOV     B,#100
        DIV     AB              ;ȡðλ DPH
        MOV     DPH,A

        MOV     A,B
        MOV     B,#10
        DIV     AB              ;ȡʮλ DPL
        MOV     DPL,A           ;ȡøλ B

        MOV     A,DPH
        CJNE    A,#00,$LKKK     ;λΪ 0, ʾ
        JMP     $NKKK
$LKKK   ADD     A,#30H
        CALL    WRITE_LCD       ;λд LCD
$NKKK
        MOV     A,DPL
        ADD     A,#30H
        CALL    WRITE_LCD       ;ʮλд LCD

        MOV     A,B
        ADD     A,#30H
        CALL    WRITE_LCD       ;λд LCD

        POP     PSW
        POP     B
        POP     ACC
        POP     DPL
        POP     DPH
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE BIN_LCD         ; ACC ,Զֵʾ
        .GLOBAL BIN_LCD
        .EXTERN WRITE_LCD
BIN_LCD PUSH    PSW             ; ACC ,Զֵʾ
        PUSH    ACC
        PUSH    B

        MOV     B,#8            ;ܹ 8 λԪ
AGAIN$  RLC     ACC
        PUSH    ACC
        JC      ONE$            ; C=1  ONE
        MOV     A,#30H
        CALL    WRITE_LCD       ;ʾ "0"
        JMP     NEXT$
ONE$    MOV     A,#31H
        CALL    WRITE_LCD       ;ʾ "1"
NEXT$   POP     ACC
        DJNZ    B,AGAIN$        ;8 λԪǷ?

        POP     B
        POP     ACC
        POP     PSW
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE STRING_LCD       ;ӡִ LCD
        .GLOBAL STRING_LCD
        .EXTERN WRITE_LCD
STRING_LCD                       ;ӡִ LCD, DPTR ı,
        PUSH    DPH              ;ִΪ 65536 .
        PUSH    DPL
        PUSH    ACC
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#FEH,STRING$ ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        INC     DPTR            ;ȡһλԪ
        JMP     LOOP$
OVER$   POP     ACC
        POP     DPL
        POP     DPH
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE STRING_LCD_      ;ӡִ LCD
        .GLOBAL STRING_LCD_
        .EXTERN WRITE_LCD
STRING_LCD_                     ;ӡִ LCD, DPTR ı,
        PUSH    ACC             ;ִΪ 65536 
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        INC     DPTR            ;ָһλַ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        JMP     LOOP$
OVER$   POP     ACC
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE STRING1_LCD     ;ӡִ LCD
        .GLOBAL STRING1_LCD
        .EXTERN WRITE_LCD
STRING1_LCD                     ;ӡִ LCD,(COUNT,'STRING')
        PUSH    B               ;DPTR ı, ִΪ 256 .
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC

        MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾ
        MOV     B,A
        INC     DPTR            ;ָһҪʾԪλַ
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CALL    WRITE_LCD
        INC     DPTR            ;ָһλַ
        DJNZ    B,LOOP$

        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE STRING1_LCD_    ;ӡִ LCD
        .GLOBAL STRING1_LCD_
        .EXTERN WRITE_LCD
STRING1_LCD_                    ;ӡִ LCD,(COUNT,'STRING'),
        PUSH    B               ;DPTR ı, ִΪ 256 .
        PUSH    ACC

        MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾ
        MOV     B,A
        INC     DPTR            ;ָһҪʾԪλַ
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CALL    WRITE_LCD
        INC     DPTR            ;ָһλַ
        DJNZ    B,LOOP$

        POP     ACC
        POP     B
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE STRING2_LCD     ;ӡִ LCD
        .GLOBAL STRING2_LCD
        .EXTERN WRITE_LCD
STRING2_LCD                     ;ӡִ LCD, DPTR ı,
        PUSH    B               ;ִΪ 256 .
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     B,#00H
LOOP$   MOV     A,B
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        INC     B               ;ָһλַ
        JMP     LOOP$
OVER$   POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        RET
        .ENDMOD
;--------------------------------------------------------------------
        .MODULE STRING2_LCD_    ;ӡִ LCD
        .GLOBAL STRING2_LCD_
        .EXTERN WRITE_LCD
STRING2_LCD_                    ;ӡִ LCD, DPTR ı,
        PUSH    B               ;ִΪ 256 .
        PUSH    ACC
        MOV     B,#00H
LOOP$   MOV     A,B
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#FEH,STRING$  ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_LCD       ;дԪ LCD
        INC     B               ;ָһλַ
        JMP     LOOP$
OVER$   POP     ACC
        POP     B
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE INITIAL_8279    ;ִ 8279 ʼ
        .GLOBAL INITIAL_8279
W_C_8279 .EQU   A4H
INITIAL_8279
        PUSH    ACC
        PUSH    DPH
        MOV     DPH,#W_C_8279
        MOV     A,#11H          ;ұ߽ʾģʽ
        MOVX    @DPTR,A         ;ʽ
        MOV     A,#34H          ;ʱ滮PPPPP=20100KHz
        MOVX    @DPTR,A
        MOV     A,#D3H          ;ʾ
        MOVX    @DPTR,A
        POP     DPH
        POP     ACC
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE CHKBUSY_GLCD1  ; 128064 өĻæµ
        .GLOBAL CHKBUSY_GLCD1
R_B_GLCD1 .EQU  B6H
CHKBUSY_GLCD1
        PUSH    DPH
        PUSH    ACC
        MOV     DPH,#R_B_GLCD1
CHK$    MOVX    A,@DPTR
        JB      ACC.7,CHK$
        POP     ACC
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE CHKBUSY_GLCD2  ; 128064 ҰөĻæµ
        .GLOBAL CHKBUSY_GLCD2
R_B_GLCD2 .EQU  BAH
CHKBUSY_GLCD2
        PUSH    DPH
        PUSH    ACC
        MOV     DPH,#R_B_GLCD2
CHK$    MOVX    A,@DPTR
        JB      ACC.7,CHK$
        POP     ACC
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE COMMAND_GLCD1   ;д 128064 өĻ
        .GLOBAL COMMAND_GLCD1
        .EXTERN CHKBUSY_GLCD1
W_C_GLCD1 .EQU  B4H
COMMAND_GLCD1
        PUSH    DPH
        CALL    CHKBUSY_GLCD1
        MOV     DPH,#W_C_GLCD1
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE COMMAND_GLCD2   ;д 128064 ҰөĻ
        .GLOBAL COMMAND_GLCD2
        .EXTERN CHKBUSY_GLCD2
W_C_GLCD2 .EQU B8H
COMMAND_GLCD2
        PUSH    DPH
        CALL    CHKBUSY_GLCD2
        MOV     DPH,#W_C_GLCD2
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE WRITE_GLCD1    ;дϵ 128064 өĻ
        .GLOBAL WRITE_GLCD1
        .EXTERN CHKBUSY_GLCD1
W_D_GLCD1 .EQU  B5H
WRITE_GLCD1
        PUSH    DPH
        CALL    CHKBUSY_GLCD1
        MOV     DPH,#W_D_GLCD1
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE WRITE_GLCD2      ;дϵ 128064 ҰөĻ
        .GLOBAL WRITE_GLCD2
        .EXTERN CHKBUSY_GLCD2
W_D_GLCD2 .EQU  B9H
WRITE_GLCD2
        PUSH    DPH
        CALL    CHKBUSY_GLCD2
        MOV     DPH,#W_D_GLCD2
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE CHKBUSY_GLCD      ; GLCD æµ
        .GLOBAL CHKBUSY_GLCD
R_B_GLCD  .EQU  B3H
CHKBUSY_GLCD
        PUSH    DPH
        PUSH    ACC
        MOV     DPH,#R_B_GLCD
CHK$    MOVX    A,@DPTR
        JB      ACC.7,CHK$
        POP     ACC
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE COMMAND_GLCD      ;д GLCD
        .GLOBAL COMMAND_GLCD
        .EXTERN CHKBUSY_GLCD
W_C_GLCD  .EQU  B1H
COMMAND_GLCD
        PUSH    DPH
        CALL    CHKBUSY_GLCD
        MOV     DPH,#W_C_GLCD
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE WRITE_GLCD        ;дϵ GLCD
        .GLOBAL WRITE_GLCD
        .EXTERN CHKBUSY_GLCD
W_D_GLCD  .EQU  B0H
WRITE_GLCD
        PUSH    DPH
        CALL    CHKBUSY_GLCD
        MOV     DPH,#W_D_GLCD
        MOVX    @DPTR,A
        POP     DPH
        RET
        .ENDMOD
;---------------------------------------------------------------
        .MODULE STRING_GLCD       ;ӡִ GLCD
        .GLOBAL STRING_GLCD
        .EXTERN WRITE_GLCD
STRING_GLCD
        PUSH    ACC
LOOP$   MOV     A,#00H
        MOVC    A,@A+DPTR       ;ȡҪʾԪ
        CJNE    A,#0FEH,STRING$ ;ǷִѾ?
        JMP     OVER$
STRING$ CALL    WRITE_GLCD      ;дԪ LCD
        INC     DPTR            ;ȡһλԪ
        JMP     LOOP$
OVER$   POP     ACC
        RET
        .ENDMOD
