;:MACRO.H
INITIAL_GLCD    .MACRO  ARG0,ARG1,ARG2,ARG3  ; LCD ʼ޼
        PUSH    ACC
        MOV     A,#04H           ;set cursor position
        CALL    COMMAND_GLCD
        MOV     A,#07H           ;Cp=8,Cp-1=7
        CALL    WRITE_GLCD
        MOV     A,#02H           ;set number of characters
        CALL    COMMAND_GLCD
        MOV     A,ARG0           ;Hn-1
        CALL    WRITE_GLCD
        MOV     A,#03H           ;set number of time division
        CALL    COMMAND_GLCD
        MOV     A,ARG1           ;Nx-1
        CALL    WRITE_GLCD
        MOV     A,#01H           ;set character pitch
        CALL    COMMAND_GLCD
        MOV     A,ARG2           ;Vp-1,Hp-1
        CALL    WRITE_GLCD
        MOV     A,#00H           ;mode control
        CALL    COMMAND_GLCD
        MOV     A,ARG3           ;display on
        CALL    WRITE_GLCD
        MOV     A,#08H           ;set displsy start low order address
        CALL    COMMAND_GLCD
        MOV     A,#00H           ;00H
        CALL    WRITE_GLCD
        MOV     A,#09H           ;set display start high order address
        CALL    COMMAND_GLCD
        MOV     A,#00H           ;00H
        CALL    WRITE_GLCD
        ADDR_GLCD      #00H,#00H
        POP     ACC
        .ENDM
;---------------------------------------------------------------
ADDR_GLCD       .MACRO  HIGH,LOW ; LCD αλַ趨޼
        PUSH    ACC
        MOV     A,#10            ;set cursor address (low order)
        CALL    COMMAND_GLCD
        MOV     A,LOW            ;low address
        CALL    WRITE_GLCD
        MOV     A,#11            ;set cursor address (high order)
        CALL    COMMAND_GLCD
        MOV     A,HIGH           ;high address
        CALL    WRITE_GLCD
        MOV     A,#12            ;write display data
        CALL    COMMAND_GLCD
        POP     ACC
        .ENDM
;---------------------------------------------------------------
WR_WORD_GLCD    .MACRO  HIGH,LOW,TABLE ;д֮޼ (趨λַ)
        PUSH    PSW
        PUSH    ACC
        PUSH    DPH
        PUSH    DPL
        PUSH    07H
        PUSH    06H
        PUSH    05H
        PUSH    04H
        MOV     R5,#HIGH
        MOV     R4,#LOW
        MOV     DPTR,#TABLE      ;move Chinese address to DPTR
        MOV     R7,#00H
        MOV     R6,#16
$WWD#   ADDR_GLCD       R5,R4    ;set cursor address
        MOV     A,R7
        MOVC    A,@A+DPTR
        CALL    WRITE_GLCD
        INC     R7
        MOV     A,R7
        MOVC    A,@A+DPTR
        CALL    WRITE_GLCD
        INC     R7
        CALL    CHANGE_NEXT      ;change next line
        DJNZ    R6,$WWD#
        POP     04H
        POP     05H
        POP     06H
        POP     07H
        POP     DPL
        POP     DPH
        POP     ACC
        POP     PSW
        .ENDM
;---------------------------------------------------------------
DELAY   .MACRO  ARG0,ARG1       ;ӳپ޼ʽ
        PUSH    06H
        PUSH    07H
        MOV     R6,ARG0
$DELAY1# MOV    R7,ARG1
        DJNZ    R7,$
        DJNZ    R6,$DELAY1#
        POP     07H
        POP     06H
        .ENDM
;---------------------------------------------------------------
L_DELAY .MACRO  ARG0,ARG1,ARG2  ;ʱӳپ޼ʽ
        PUSH    05H
        PUSH    06H
        PUSH    07H
        MOV     R5,ARG0
$DELAY2# MOV    R6,ARG1
$DELAY3# MOV    R7,ARG2
        DJNZ    R7,$
        DJNZ    R6,$DELAY3#
        DJNZ    R5,$DELAY2#
        POP     07H
        POP     06H
        POP     05H
        .ENDM
;---------------------------------------------------------------
SET_8255 .MACRO PORT,WORD       ;д 8255 Ŀݴ
        PUSH    DPH
        PUSH    ACC
        MOV     DPH,#PORT
        MOV     A,WORD
        MOVX    @DPTR,A
        POP     ACC
        POP     DPH
        .ENDM
;---------------------------------------------------------------
OUT_8255 .MACRO PORT            ;CPU  8255 I/O ͳ
        PUSH    DPH
        MOV     DPH,#PORT
        MOVX    @DPTR,A
        POP     DPH
        .ENDM
;---------------------------------------------------------------
IN_8255 .MACRO  PORT            ;CPU  8255 I/O 
        PUSH    DPH
        MOV     DPH,#PORT
        MOVX    A,@DPTR
        POP     DPH
        .ENDM
;--------------------------------------------------------------------
        .MACDELIM (
PRINTF_LCD .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), α괦ʼ
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CJNE    A,#0FEH,$STRNG#
        JMP     $OVER#
$STRNG# CALL    WRITE_LCD
        INC     DPTR
        JMP     $LOOP#
$TRRR#  .DB     STRING,0FEH
$OVER#  POP     ACC
        POP     DPL
        POP     DPH
        .ENDM
;--------------------------------------------------------------------
PRINTF_LCD_1 .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), ӵһпʼ
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_1
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CJNE    A,#0FEH,$STRNG#
        JMP     $OVER#
$STRNG# CALL    WRITE_LCD
        INC     DPTR
        JMP     $LOOP#
$TRRR#  .DB     STRING,0FEH
$OVER#  POP     ACC
        POP     DPL
        POP     DPH
        .ENDM
;--------------------------------------------------------------------
PRINTF_LCD_2 .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), ӵڶпʼ
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_2
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CJNE    A,#0FEH,$STRNG#
        JMP     $OVER#
$STRNG# CALL    WRITE_LCD
        INC     DPTR
        JMP     $LOOP#
$TRRR#  .DB     STRING,0FEH
$OVER#  POP     ACC
        POP     DPL
        POP     DPH
        .ENDM
;--------------------------------------------------------------------
PRINTF_LCD_3 .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), ӵпʼ
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_3
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CJNE    A,#0FEH,$STRNG#
        JMP     $OVER#
$STRNG# CALL    WRITE_LCD
        INC     DPTR
        JMP     $LOOP#
$TRRR#  .DB     STRING,0FEH
$OVER#  POP     ACC
        POP     DPL
        POP     DPH
        .ENDM
;--------------------------------------------------------------------
PRINTF_LCD_4 .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), ӵпʼ
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_4
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CJNE    A,#0FEH,$STRNG#
        JMP     $OVER#
$STRNG# CALL    WRITE_LCD
        INC     DPTR
        JMP     $LOOP#
$TRRR#  .DB     STRING,0FEH
$OVER#  POP     ACC
        POP     DPL
        POP     DPH
        .ENDM
;--------------------------------------------------------------------
PRINTF1_LCD .MACRO STRING ;ӡִ LCD, ʽ (COUNT,'STRING'), α괦ʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     DPTR,#$TRRR#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        INC     DPTR
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF1_LCD_1 .MACRO STRING ;ӡִ LCD, ʽ (COUNT,'STRING'), ӵһпʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_1
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        INC     DPTR
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF1_LCD_2 .MACRO STRING ;ӡִ LCD, ʽ (COUNT,'STRING'), ӵڶпʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_2
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        INC     DPTR
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF1_LCD_3 .MACRO STRING ;ӡִ LCD, ʽ (COUNT,'STRING'), ӵпʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_3
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        INC     DPTR
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF1_LCD_4 .MACRO STRING ;ӡִ LCD, ʽ (COUNT,'STRING'), ӵпʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     A,#COLUMN_4
        CALL    COMMAND_LCD
        MOV     DPTR,#$TRRR#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        INC     DPTR
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF2_LCD .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), α괦ʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     DPTR,#$TRRR#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        INC     DPTR
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     ($OVER#-$-1)
        .DB     STRING
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF3_LCD .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), α괦ʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     DPTR,#$NUMBE#
        MOV     A,#00H
        MOVC    A,@A+DPTR
        MOV     B,A
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$NUMBE# .DB     ($-$TRRR#)
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
PRINTF4_LCD .MACRO STRING ;ӡִ LCD, ʽ ('STRING'), α괦ʼ
        PUSH    B
        PUSH    DPH
        PUSH    DPL
        PUSH    ACC
        MOV     B,#$NUMBE#
        MOV     DPTR,#$TRRR#
$LOOP#  MOV     A,#00H
        MOVC    A,@A+DPTR
        CALL    WRITE_LCD
        INC     DPTR
        DJNZ    B,$LOOP#
        POP     ACC
        POP     DPL
        POP     DPH
        POP     B
        JMP     $OVER#
$TRRR#  .DB     STRING
$NUMBE# .EQU    ($-$TRRR#)
$OVER#  NOP
        .ENDM
;--------------------------------------------------------------------
XY_LCD  .MACRO  X,Y               ;LCD αͣڵXеY+1λ
        PUSH    ACC
        MOV     A,#COLUMN_|X|+|Y
        CALL    COMMAND_LCD
        POP     ACC
        .ENDM
